/*
 * Decompiled with CFR 0.152.
 */
package com.ghzdude.randomizer.special.generators;

import com.ghzdude.randomizer.RandomizerCore;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;

public class FireworkGenerator {
    private static final FireworkExplosion.Shape[] SHAPES = FireworkExplosion.Shape.values();
    private static final DyeColor[] COLORS = DyeColor.values();

    public static void applyFirework(ItemStack stack) {
        Random random = RandomizerCore.unseededRNG;
        int chance = random.nextInt(100) + 1;
        ArrayList<FireworkExplosion> explosions = new ArrayList<FireworkExplosion>();
        if (chance > 25) {
            for (int i = 0; i < random.nextInt(4) + 1; ++i) {
                explosions.add(FireworkGenerator.createExplosion());
            }
        }
        stack.set(DataComponents.FIREWORKS, (Object)new Fireworks(random.nextInt(6) + 1, explosions));
    }

    public static void applyFireworkStar(ItemStack stack) {
        stack.set(DataComponents.FIREWORK_EXPLOSION, (Object)FireworkGenerator.createExplosion());
    }

    private static FireworkExplosion createExplosion() {
        Random random = RandomizerCore.unseededRNG;
        FireworkExplosion.Shape shape = SHAPES[random.nextInt(SHAPES.length)];
        IntList colors = IntList.of((int)COLORS[random.nextInt(COLORS.length)].getFireworkColor());
        IntList fade = IntList.of((int)COLORS[random.nextInt(COLORS.length)].getFireworkColor());
        return new FireworkExplosion(shape, colors, fade, random.nextBoolean(), random.nextBoolean());
    }
}

