/*
 * Decompiled with CFR 0.152.
 */
package com.ghzdude.randomizer.special.generators;

import com.ghzdude.randomizer.RandomizerCore;
import com.ghzdude.randomizer.util.RandomizerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.SuspiciousStewEffects;

public class PotionGenerator {
    public static final List<Potion> BLACKLISTED_POTIONS = List.of((Potion)Potions.AWKWARD.get(), (Potion)Potions.THICK.get(), (Potion)Potions.WATER.get(), (Potion)Potions.MUNDANE.get());
    public static Map<ResourceLocation, Potion> VALID_POTIONS = new HashMap<ResourceLocation, Potion>();
    public static List<ResourceLocation> POTION_NAMES = new ArrayList<ResourceLocation>();
    public static final Map<ResourceLocation, MobEffect> VALID_EFFECTS = new HashMap<ResourceLocation, MobEffect>();
    public static List<ResourceLocation> EFFECT_NAMES = new ArrayList<ResourceLocation>();
    private static Registry<MobEffect> EFFECT_REGISTRY;

    public static void init(RegistryAccess access) {
        PotionGenerator.initEffects((Registry<MobEffect>)access.lookupOrThrow(Registries.MOB_EFFECT));
        PotionGenerator.initPotions((Registry<Potion>)access.lookupOrThrow(Registries.POTION));
    }

    public static boolean canHaveEffect(ItemStack stack) {
        return stack.has(DataComponents.POTION_CONTENTS) || stack.has(DataComponents.SUSPICIOUS_STEW_EFFECTS);
    }

    private static void initPotions(Registry<Potion> potions) {
        potions.stream().filter(potion -> !BLACKLISTED_POTIONS.contains(potion)).forEach(potion -> {
            VALID_POTIONS.put(potions.getKey(potion), (Potion)potion);
            POTION_NAMES.add(potions.getKey(potion));
        });
    }

    private static void initEffects(Registry<MobEffect> effects) {
        effects.stream().forEach(mobEffect -> {
            ResourceLocation loc = effects.getKey(mobEffect);
            VALID_EFFECTS.put(loc, (MobEffect)mobEffect);
            EFFECT_NAMES.add(loc);
        });
        EFFECT_REGISTRY = effects;
    }

    public static void applyEffect(ItemStack stack) {
        Random rng = RandomizerCore.seededRNG;
        int numOfEffects = rng.nextInt(3) + 1;
        if (stack.getItem() == Items.SUSPICIOUS_STEW) {
            PotionGenerator.makeStew(stack, rng, numOfEffects);
        } else {
            PotionGenerator.makePotion(stack, rng, numOfEffects);
        }
    }

    private static void makeStew(ItemStack stack, Random rng, int numOfEffects) {
        ArrayList<MutableComponent> lore = new ArrayList<MutableComponent>();
        lore.add(Component.translatable((String)"randomizer.stew.lore.1"));
        lore.add(Component.translatable((String)"randomizer.stew.lore.2", (Object[])new Object[]{numOfEffects}));
        stack.set(DataComponents.LORE, (Object)new ItemLore(lore));
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(numOfEffects);
        PotionGenerator.addEffects(list, numOfEffects);
        List<SuspiciousStewEffects.Entry> effects = list.stream().map(arg_0 -> EFFECT_REGISTRY.get(arg_0)).map(Optional::orElseThrow).map(holder -> new SuspiciousStewEffects.Entry((Holder)holder, rng.nextInt(100, 2001))).toList();
        stack.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)new SuspiciousStewEffects(effects));
    }

    private static void makePotion(ItemStack stack, Random rng, int numOfEffects) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(numOfEffects);
        PotionGenerator.addEffects(list, numOfEffects);
        List<MobEffectInstance> effects = list.stream().map(loc -> Holder.direct((Object)VALID_EFFECTS.get(loc))).map(holder -> new MobEffectInstance(holder, rng.nextInt(200, 2001), rng.nextInt(4) + 1)).toList();
        int color = rng.nextInt(0xFFFFFF);
        stack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.of(Potions.WATER), Optional.of(color), effects, Optional.empty()));
        MutableComponent itemType = Component.translatable((String)stack.getItem().getDescriptionId());
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"randomizer.potion_title", (Object[])new Object[]{itemType}));
        ArrayList<MutableComponent> lore = new ArrayList<MutableComponent>();
        lore.add(Component.translatable((String)"randomizer.potion_lore", (Object[])new Object[]{itemType}));
        stack.set(DataComponents.LORE, (Object)new ItemLore(lore));
    }

    private static void addEffects(List<ResourceLocation> list, int amount) {
        for (int i = 0; i < amount; ++i) {
            ResourceLocation loc = RandomizerUtil.getRandom(EFFECT_NAMES, RandomizerCore.unseededRNG);
            if (list.contains(loc)) {
                --i;
                continue;
            }
            list.add(loc);
        }
    }
}

