/*
 * Decompiled with CFR 0.152.
 */
package com.ghzdude.randomizer.special.passages;

public record Passage(String author, String title, String body) {
    public static final int MAX_CHARS = 255;
    public static final int MAX_PAGES = 100;

    public String[] parseBody() {
        int newlinesCount = this.body.split("\n").length - 1;
        int pages = Math.floorDiv(this.body.length() + (newlinesCount *= Math.floorDiv(255, 2)), 255) + 1;
        if (pages > 100) {
            pages = 100;
        }
        String[] formatted = new String[pages];
        int start = 0;
        for (int i = 0; i < pages; ++i) {
            String page;
            int end = Math.min(start + 255, this.body.length());
            int lastSpace = this.body.substring(start, end).lastIndexOf(" ");
            int lastDot = this.body.substring(start, end).lastIndexOf(".");
            int lastNewLine = this.body.substring(start, end).lastIndexOf("\n");
            int index = Math.max(lastSpace, lastDot) + 1;
            if (lastNewLine > 0) {
                index = Math.min(++lastNewLine, index);
            }
            formatted[i] = page = this.body.substring(start, start + index);
            start += index;
        }
        return formatted;
    }
}

