/*
 * Decompiled with CFR 0.152.
 */
package com.ghzdude.randomizer.util;

import com.ghzdude.randomizer.ItemRandomizer;
import com.ghzdude.randomizer.RandomizerCore;
import com.ghzdude.randomizer.RecipeRandomizer;
import com.ghzdude.randomizer.StructureRandomizer;
import com.ghzdude.randomizer.special.generators.BookGenerator;
import com.ghzdude.randomizer.special.generators.EnchantmentGenerator;
import com.ghzdude.randomizer.special.generators.FireworkGenerator;
import com.ghzdude.randomizer.special.generators.GoatHornGenerator;
import com.ghzdude.randomizer.special.generators.PotionGenerator;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class RandomizerUtil {
    private static boolean init;
    private static final Logger LOGGER;

    public static void init(RegistryAccess access) {
        StructureRandomizer.init(access);
        EnchantmentGenerator.init(access);
        PotionGenerator.init(access);
        GoatHornGenerator.init((HolderLookup.Provider)access);
        init = true;
    }

    public static void dispose() {
        RecipeRandomizer.dispose();
        init = false;
    }

    public static int giveMultiple(int pointsToUse, Inventory playerInventory) {
        for (int tries = 0; tries < 5 && pointsToUse > 0; ++tries) {
            pointsToUse = RandomizerUtil.giveOnce(pointsToUse, playerInventory);
        }
        return pointsToUse;
    }

    public static int giveOnce(int pointsToUse, Inventory playerInventory) {
        Item selectedItem = ItemRandomizer.getRandomItem(pointsToUse);
        ItemStack stack = RandomizerUtil.specialItemToStack(selectedItem, pointsToUse);
        RandomizerUtil.addStackToPlayer(stack, playerInventory);
        return pointsToUse -= stack.getCount() * ItemRandomizer.getPointValue(selectedItem);
    }

    public static void addStackToPlayer(ItemStack stack, Inventory inventory) {
        LOGGER.warn("Given {} to {}.", (Object)stack.copy(), (Object)inventory.player.getName().getString());
        if (!inventory.add(stack)) {
            inventory.player.drop(stack, false);
        }
        ItemRandomizer.incrementAmtItemsGiven(inventory.player);
    }

    public static <T> T getRandom(List<T> list, Random rng) {
        return list.get(rng.nextInt(list.size()));
    }

    public static <T> T getRandom(List<T> list) {
        return RandomizerUtil.getRandom(list, RandomizerCore.unseededRNG);
    }

    @NotNull
    public static <T> T getOrThrow(Registry<T> registry, ResourceLocation location) {
        return (T)((Holder.Reference)registry.get(location).orElseThrow()).get();
    }

    public static ItemStack specialItemToStack(Item item, int points) {
        int amtToGive = Math.floorDiv(points, ItemRandomizer.getPointValue(item));
        return RandomizerUtil.itemToStack(item, amtToGive);
    }

    public static ItemStack itemToStack(Item item) {
        return RandomizerUtil.itemToStack(item, 1);
    }

    public static ItemStack itemToStack(Item item, int size) {
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.setCount(Math.min(size, stack.getMaxStackSize()));
        if (!init) {
            return stack;
        }
        if (EnchantmentGenerator.canEnchant(stack)) {
            EnchantmentGenerator.applyEnchantment(stack);
        } else if (PotionGenerator.canHaveEffect(stack)) {
            PotionGenerator.applyEffect(stack);
        } else if (item == Items.WRITTEN_BOOK) {
            BookGenerator.applyPassages(stack);
        } else if (item == Items.FIREWORK_ROCKET) {
            FireworkGenerator.applyFirework(stack);
        } else if (item == Items.FIREWORK_STAR) {
            FireworkGenerator.applyFireworkStar(stack);
        } else if (item == Items.GOAT_HORN) {
            GoatHornGenerator.applyGoatHornSound(stack);
        }
        return stack;
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"randomizer", (String)path);
    }

    @NotNull
    public static List<Component> getOrCreateLines(ItemStack inputStack) {
        return Optional.ofNullable((ItemLore)inputStack.get(DataComponents.LORE)).map(itemLore -> new ArrayList(itemLore.lines())).orElse(new ArrayList());
    }

    static {
        LOGGER = LogUtils.getLogger();
    }
}

