/*
 * Decompiled with CFR 0.152.
 */
package com.nenio.farmlandwater;

import com.nenio.farmlandwater.ModBlocks;
import com.nenio.farmlandwater.WaterSurfacePlatformBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="farmlandwater")
public class farmlandwater {
    public static final String MOD_ID = "farmlandwater";
    public static GameRules.Key<GameRules.BooleanValue> GR_FARMLAND_WATER;
    private static final Direction[] CARDINALS;
    private static final int SCAN_RADIUS = 8;
    private static final int SCAN_Y_RANGE = 6;
    private static final int SCAN_EVERY_TICKS = 10;

    public farmlandwater() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBlocks.BLOCKS.register(modBus);
        modBus.addListener(this::onCommonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            GR_FARMLAND_WATER = GameRules.register((String)"FarmlandWater", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.create((boolean)true));
            return GR_FARMLAND_WATER;
        });
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level level = player.level();
        if (level.isClientSide) {
            return;
        }
        boolean enabled = farmlandwater.isFeatureEnabled(level);
        if (player.tickCount % 10 != 0) {
            return;
        }
        int px = (int)Math.floor(player.getX());
        int pz = (int)Math.floor(player.getZ());
        int topY = level.getHeight(Heightmap.Types.WORLD_SURFACE, px, pz);
        int yMin = Math.max(level.getMinBuildHeight(), topY - 6);
        int yMax = Math.min(level.getMaxBuildHeight() - 1, topY + 6);
        for (int x = px - 8; x <= px + 8; ++x) {
            for (int z = pz - 8; z <= pz + 8; ++z) {
                for (int y = yMax; y >= yMin; --y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState st = level.getBlockState(pos);
                    if (enabled) {
                        if (st.getBlock() instanceof FarmBlock) {
                            farmlandwater.placePlatformsAroundFarmland(level, pos);
                            continue;
                        }
                        if (!st.is((Block)ModBlocks.WATER_SURFACE_PLATFORM.get()) || farmlandwater.hasAdjacentFarmland(level, pos)) continue;
                        level.setBlock(pos, Blocks.WATER.defaultBlockState(), 2);
                        continue;
                    }
                    if (!st.is((Block)ModBlocks.WATER_SURFACE_PLATFORM.get())) continue;
                    level.setBlock(pos, Blocks.WATER.defaultBlockState(), 2);
                }
            }
        }
    }

    @SubscribeEvent
    public void onFarmlandBreak(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        if (level.isClientSide) {
            return;
        }
        if (event.getState().getBlock() instanceof FarmBlock) {
            farmlandwater.revertPlatformsAround(level, event.getPos());
        }
    }

    @SubscribeEvent
    public void onWaterPlacedByEntity(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        if (level.isClientSide) {
            return;
        }
        if (!farmlandwater.isFeatureEnabled(level)) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState placed = event.getPlacedBlock();
        if ((level.getFluidState(pos).is((Fluid)Fluids.WATER) || placed.getFluidState().is((Fluid)Fluids.WATER)) && !level.getBlockState(pos).is((Block)ModBlocks.WATER_SURFACE_PLATFORM.get())) {
            farmlandwater.maybeConvertWaterToPlatform(level, pos);
        }
    }

    @SubscribeEvent
    public void onFluidPlaced(BlockEvent.FluidPlaceBlockEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        if (level.isClientSide) {
            return;
        }
        if (!farmlandwater.isFeatureEnabled(level)) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState newState = event.getNewState();
        if (level.getBlockState(pos).is((Block)ModBlocks.WATER_SURFACE_PLATFORM.get())) {
            return;
        }
        if (level.getFluidState(pos).is((Fluid)Fluids.WATER) || newState.getFluidState().is((Fluid)Fluids.WATER)) {
            farmlandwater.maybeConvertWaterToPlatform(level, pos);
        }
    }

    private static void placePlatformsAroundFarmland(Level level, BlockPos farmlandPos) {
        for (Direction dir : CARDINALS) {
            BlockPos wpos = farmlandPos.relative(dir);
            if (level.getFluidState(wpos).is((Fluid)Fluids.WATER)) {
                if (level.getBlockState(wpos).is((Block)ModBlocks.WATER_SURFACE_PLATFORM.get())) continue;
                BlockState platform = (BlockState)((Block)ModBlocks.WATER_SURFACE_PLATFORM.get()).defaultBlockState().setValue((Property)WaterSurfacePlatformBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                level.setBlock(wpos, platform, 2);
                continue;
            }
            if (!level.getBlockState(wpos).is((Block)ModBlocks.WATER_SURFACE_PLATFORM.get()) || farmlandwater.hasAdjacentFarmland(level, wpos)) continue;
            level.setBlock(wpos, Blocks.WATER.defaultBlockState(), 2);
        }
    }

    private static void revertPlatformsAround(Level level, BlockPos oldFarmland) {
        for (Direction dir : CARDINALS) {
            BlockPos pos = oldFarmland.relative(dir);
            if (!level.getBlockState(pos).is((Block)ModBlocks.WATER_SURFACE_PLATFORM.get()) || farmlandwater.hasAdjacentFarmland(level, pos)) continue;
            level.setBlock(pos, Blocks.WATER.defaultBlockState(), 2);
        }
    }

    private static void maybeConvertWaterToPlatform(Level level, BlockPos pos) {
        if (!level.getFluidState(pos).is((Fluid)Fluids.WATER)) {
            return;
        }
        if (!farmlandwater.hasAdjacentFarmland(level, pos)) {
            return;
        }
        BlockState platform = (BlockState)((Block)ModBlocks.WATER_SURFACE_PLATFORM.get()).defaultBlockState().setValue((Property)WaterSurfacePlatformBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        level.setBlock(pos, platform, 2);
    }

    private static boolean hasAdjacentFarmland(Level level, BlockPos pos) {
        for (Direction d : CARDINALS) {
            if (!(level.getBlockState(pos.relative(d)).getBlock() instanceof FarmBlock)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFeatureEnabled(Level level) {
        try {
            GameRules rules = level.getGameRules();
            return rules != null && GR_FARMLAND_WATER != null ? rules.getBoolean(GR_FARMLAND_WATER) : true;
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    static {
        CARDINALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    }
}

