/*
 * Decompiled with CFR 0.152.
 */
package com.nenio.farmlandwater;

import com.nenio.farmlandwater.ModBlocks;
import com.nenio.farmlandwater.WaterSurfacePlatformBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@Mod(value="farmlandwater")
public class farmlandwater {
    public static final String MOD_ID = "farmlandwater";
    public static GameRules.Key<GameRules.BooleanValue> GR_FARMLAND_WATER;
    private static final Direction[] CARDINALS;
    private static final int SCAN_RADIUS = 8;
    private static final int SCAN_Y_RANGE = 6;
    private static final int SCAN_EVERY_TICKS = 10;

    public farmlandwater(IEventBus modBus) {
        ModBlocks.BLOCKS.register(modBus);
        modBus.addListener(this::onCommonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            GR_FARMLAND_WATER = GameRules.register((String)"FarmlandWater", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.create((boolean)true));
            return GR_FARMLAND_WATER;
        });
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (level.isClientSide) {
            return;
        }
        boolean enabled = farmlandwater.isFeatureEnabled(level);
        if (player.tickCount % 10 != 0) {
            return;
        }
        int px = (int)Math.floor(player.getX());
        int pz = (int)Math.floor(player.getZ());
        int topY = level.getHeight(Heightmap.Types.WORLD_SURFACE, px, pz);
        int worldMinY = level.dimensionType().minY();
        int worldMaxY = worldMinY + level.dimensionType().height() - 1;
        int yMin = Math.max(worldMinY, topY - 6);
        int yMax = Math.min(worldMaxY, topY + 6);
        for (int x = px - 8; x <= px + 8; ++x) {
            for (int z = pz - 8; z <= pz + 8; ++z) {
                for (int y = yMax; y >= yMin; --y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState st = level.getBlockState(pos);
                    if (enabled) {
                        if (st.getBlock() instanceof FarmBlock) {
                            farmlandwater.placePlatformsAroundFarmland(level, pos);
                            continue;
                        }
                        if (!st.is((Block)ModBlocks.WATER_SURFACE_PLATFORM.get()) || farmlandwater.hasAdjacentFarmland(level, pos)) continue;
                        level.setBlock(pos, Blocks.WATER.defaultBlockState(), 2);
                        continue;
                    }
                    if (!st.is((Block)ModBlocks.WATER_SURFACE_PLATFORM.get())) continue;
                    level.setBlock(pos, Blocks.WATER.defaultBlockState(), 2);
                }
            }
        }
    }

    @SubscribeEvent
    public void onFarmlandBreak(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        if (level.isClientSide) {
            return;
        }
        if (event.getState().getBlock() instanceof FarmBlock) {
            farmlandwater.revertPlatformsAround(level, event.getPos());
        }
    }

    @SubscribeEvent
    public void onWaterPlacedByEntity(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        if (level.isClientSide) {
            return;
        }
        if (!farmlandwater.isFeatureEnabled(level)) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState placed = event.getPlacedBlock();
        if ((level.getFluidState(pos).is((Fluid)Fluids.WATER) || placed.getFluidState().is((Fluid)Fluids.WATER)) && !level.getBlockState(pos).is((Block)ModBlocks.WATER_SURFACE_PLATFORM.get())) {
            farmlandwater.maybeConvertWaterToPlatform(level, pos);
        }
    }

    @SubscribeEvent
    public void onFluidPlaced(BlockEvent.FluidPlaceBlockEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        if (level.isClientSide) {
            return;
        }
        if (!farmlandwater.isFeatureEnabled(level)) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState newState = event.getNewState();
        if (level.getBlockState(pos).is((Block)ModBlocks.WATER_SURFACE_PLATFORM.get())) {
            return;
        }
        if (level.getFluidState(pos).is((Fluid)Fluids.WATER) || newState.getFluidState().is((Fluid)Fluids.WATER)) {
            farmlandwater.maybeConvertWaterToPlatform(level, pos);
        }
    }

    private static void placePlatformsAroundFarmland(Level level, BlockPos farmlandPos) {
        for (Direction dir : CARDINALS) {
            BlockPos wpos = farmlandPos.relative(dir);
            if (level.getFluidState(wpos).is((Fluid)Fluids.WATER)) {
                if (level.getBlockState(wpos).is((Block)ModBlocks.WATER_SURFACE_PLATFORM.get())) continue;
                BlockState platform = (BlockState)((WaterSurfacePlatformBlock)((Object)ModBlocks.WATER_SURFACE_PLATFORM.get())).defaultBlockState().setValue((Property)WaterSurfacePlatformBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                level.setBlock(wpos, platform, 2);
                continue;
            }
            if (!level.getBlockState(wpos).is((Block)ModBlocks.WATER_SURFACE_PLATFORM.get())) continue;
            level.setBlock(wpos, Blocks.AIR.defaultBlockState(), 2);
        }
    }

    private static void revertPlatformsAround(Level level, BlockPos oldFarmland) {
        for (Direction dir : CARDINALS) {
            BlockPos pos = oldFarmland.relative(dir);
            if (!level.getBlockState(pos).is((Block)ModBlocks.WATER_SURFACE_PLATFORM.get()) || farmlandwater.hasAdjacentFarmland(level, pos)) continue;
            level.setBlock(pos, Blocks.WATER.defaultBlockState(), 2);
        }
    }

    private static void maybeConvertWaterToPlatform(Level level, BlockPos pos) {
        if (!level.getFluidState(pos).is((Fluid)Fluids.WATER)) {
            return;
        }
        if (!farmlandwater.hasAdjacentFarmland(level, pos)) {
            return;
        }
        BlockState platform = (BlockState)((WaterSurfacePlatformBlock)((Object)ModBlocks.WATER_SURFACE_PLATFORM.get())).defaultBlockState().setValue((Property)WaterSurfacePlatformBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        level.setBlock(pos, platform, 2);
    }

    private static boolean hasAdjacentFarmland(Level level, BlockPos pos) {
        for (Direction d : CARDINALS) {
            if (!(level.getBlockState(pos.relative(d)).getBlock() instanceof FarmBlock)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFeatureEnabled(Level level) {
        try {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                GameRules rules = serverLevel.getGameRules();
                return GR_FARMLAND_WATER != null ? rules.getBoolean(GR_FARMLAND_WATER) : true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    static {
        CARDINALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    }
}

