/*
 * Decompiled with CFR 0.152.
 */
package com.nenio.farmlandwater;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WaterSurfacePlatformBlock
extends Block
implements SimpleWaterloggedBlock,
BucketPickup {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape TOP_PLATE = Block.box((double)0.25, (double)14.0, (double)0.25, (double)15.75, (double)15.0, (double)15.75);
    private static final double CAPTURE_TOLERANCE = 0.125;
    private static final double UPWARD_EPS = 0.001;

    public WaterSurfacePlatformBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{WATERLOGGED});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            return Shapes.empty();
        }
        return WaterSurfacePlatformBlock.collidesFromTopOrNearTop(ctx, pos) ? TOP_PLATE : Shapes.empty();
    }

    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? TOP_PLATE : Shapes.empty();
    }

    public VoxelShape getShape(BlockState s, BlockGetter l, BlockPos p, CollisionContext c) {
        return Shapes.empty();
    }

    public VoxelShape getVisualShape(BlockState s, BlockGetter l, BlockPos p, CollisionContext c) {
        return Shapes.empty();
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState nd, LevelAccessor level, BlockPos pos, BlockPos nPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
            return state;
        }
        return Blocks.AIR.defaultBlockState();
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public ItemStack pickupBlock(LevelAccessor level, BlockPos pos, BlockState state) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            return new ItemStack((ItemLike)Items.WATER_BUCKET);
        }
        return ItemStack.EMPTY;
    }

    public Optional<SoundEvent> getPickupSound() {
        return Fluids.WATER.getPickupSound();
    }

    private static boolean collidesFromTopOrNearTop(CollisionContext ctx, BlockPos pos) {
        if (ctx instanceof EntityCollisionContext) {
            EntityCollisionContext ecc = (EntityCollisionContext)ctx;
            Entity e = ecc.getEntity();
            if (e == null) {
                return false;
            }
            double topY = (double)pos.getY() + 1.0;
            double minY = e.getBoundingBox().minY;
            double vy = e.getDeltaMovement().y;
            boolean withinCaptureBand = minY >= topY - 0.125;
            boolean notGoingUp = vy <= 0.001;
            return withinCaptureBand && notGoingUp;
        }
        return false;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext ctx) {
        if (ctx.isSecondaryUseActive()) {
            return false;
        }
        ItemStack stack = ctx.getItemInHand();
        return stack.getItem() instanceof BlockItem;
    }
}

