/*
 * Decompiled with CFR 0.152.
 */
package com.nenio.farmlandwater;

import com.nenio.farmlandwater.ModBlocks;
import com.nenio.farmlandwater.WaterSurfacePlatformBlock;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class farmlandwater
implements ModInitializer {
    public static final String MOD_ID = "farmlandwater";
    public static class_1928.class_4313<class_1928.class_4310> GR_FARMLAND_WATER;
    private static final class_2350[] CARDINALS;
    private static final int SCAN_RADIUS = 8;
    private static final int SCAN_Y_RANGE = 6;
    private static final int SCAN_EVERY_TICKS = 10;

    public void onInitialize() {
        ModBlocks.register();
        GR_FARMLAND_WATER = GameRuleRegistry.register((String)"FarmlandWater", (class_1928.class_5198)class_1928.class_5198.field_24094, (class_1928.class_4314)GameRuleFactory.createBooleanRule((boolean)true));
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            if (world.method_8510() % 10L != 0L) {
                return;
            }
            world.method_18456().forEach(p -> farmlandwater.scanAroundPlayer(world, p.method_31477(), p.method_31479()));
        });
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, be) -> {
            if (state.method_26204() instanceof class_2344) {
                farmlandwater.revertPlatformsAround(world, pos);
            }
        });
    }

    private static void scanAroundPlayer(class_3218 world, int px, int pz) {
        boolean enabled = farmlandwater.isFeatureEnabled((class_1937)world);
        int topY = world.method_8624(class_2902.class_2903.field_13202, px, pz);
        int worldMinY = world.method_31607();
        int worldMaxY = worldMinY + world.method_31605() - 1;
        int yMin = Math.max(worldMinY, topY - 6);
        int yMax = Math.min(worldMaxY, topY + 6);
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = px - 8; x <= px + 8; ++x) {
            for (int z = pz - 8; z <= pz + 8; ++z) {
                for (int y = yMax; y >= yMin; --y) {
                    pos.method_10103(x, y, z);
                    class_2680 st = world.method_8320((class_2338)pos);
                    if (enabled) {
                        if (st.method_26204() instanceof class_2344) {
                            farmlandwater.placePlatformsAroundFarmland((class_1937)world, (class_2338)pos);
                            continue;
                        }
                        if (!st.method_27852((class_2248)ModBlocks.WATER_SURFACE_PLATFORM) || farmlandwater.hasAdjacentFarmland((class_1937)world, (class_2338)pos)) continue;
                        world.method_8652((class_2338)pos, class_2246.field_10382.method_9564(), 3);
                        continue;
                    }
                    if (!st.method_27852((class_2248)ModBlocks.WATER_SURFACE_PLATFORM)) continue;
                    world.method_8652((class_2338)pos, class_2246.field_10382.method_9564(), 3);
                }
            }
        }
    }

    private static void placePlatformsAroundFarmland(class_1937 world, class_2338 farmlandPos) {
        for (class_2350 dir : CARDINALS) {
            class_2338 wpos = farmlandPos.method_10093(dir);
            if (world.method_8316(wpos).method_39360((class_3611)class_3612.field_15910)) {
                if (world.method_8320(wpos).method_27852((class_2248)ModBlocks.WATER_SURFACE_PLATFORM)) continue;
                class_2680 platform = (class_2680)ModBlocks.WATER_SURFACE_PLATFORM.method_9564().method_11657((class_2769)WaterSurfacePlatformBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                world.method_8652(wpos, platform, 3);
                continue;
            }
            if (!world.method_8320(wpos).method_27852((class_2248)ModBlocks.WATER_SURFACE_PLATFORM)) continue;
            world.method_8652(wpos, class_2246.field_10124.method_9564(), 3);
        }
    }

    private static void revertPlatformsAround(class_1937 world, class_2338 oldFarmland) {
        for (class_2350 dir : CARDINALS) {
            class_2338 pos = oldFarmland.method_10093(dir);
            if (!world.method_8320(pos).method_27852((class_2248)ModBlocks.WATER_SURFACE_PLATFORM) || farmlandwater.hasAdjacentFarmland(world, pos)) continue;
            world.method_8652(pos, class_2246.field_10382.method_9564(), 3);
        }
    }

    private static void maybeConvertWaterToPlatform(class_1937 world, class_2338 pos) {
        if (!world.method_8316(pos).method_39360((class_3611)class_3612.field_15910)) {
            return;
        }
        if (!farmlandwater.hasAdjacentFarmland(world, pos)) {
            return;
        }
        class_2680 platform = (class_2680)ModBlocks.WATER_SURFACE_PLATFORM.method_9564().method_11657((class_2769)WaterSurfacePlatformBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        world.method_8652(pos, platform, 3);
    }

    private static boolean hasAdjacentFarmland(class_1937 world, class_2338 pos) {
        for (class_2350 d : CARDINALS) {
            if (!(world.method_8320(pos.method_10093(d)).method_26204() instanceof class_2344)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFeatureEnabled(class_1937 world) {
        if (world instanceof class_3218) {
            class_3218 sw = (class_3218)world;
            return sw.method_64395().method_8355(GR_FARMLAND_WATER);
        }
        return true;
    }

    static {
        CARDINALS = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034};
    }
}

