/*
 * Decompiled with CFR 0.152.
 */
package me.andy.basicsmodplus.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.andy.basicsmodplus.api.IPlayerInventoryListener;
import me.andy.basicsmodplus.util.OfflinePlayerUtil;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_11343;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_4095;
import net.minecraft.class_5455;
import net.minecraft.class_747;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class PlayerViewingCommands {
    private static final String PERM_INVSEE = "basicsmod.invsee";
    private static final String PERM_ENDSEE = "basicsmod.endsee";
    private static final SimpleCommandExceptionType OFFLINE_PLAYER_NOT_FOUND = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"That player has never joined the server."));
    private static final int[] PLACEHOLDER_SLOTS = new int[]{41, 42, 43, 44};
    private static final Map<Integer, Integer> NBT_ARMOR_SLOT_MAP = new HashMap<Integer, Integer>();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"invsee").requires(source -> source.method_9259(4) || Permissions.check((class_2172)source, (String)PERM_INVSEE, (boolean)false))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2191.method_9329()).executes(context -> PlayerViewingCommands.executeInvSee((class_2168)context.getSource(), (GameProfile)class_2191.method_9330((CommandContext)context, (String)"target").iterator().next()))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"endsee").requires(source -> source.method_9259(4) || Permissions.check((class_2172)source, (String)PERM_ENDSEE, (boolean)false))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2191.method_9329()).executes(context -> PlayerViewingCommands.executeEndSee((class_2168)context.getSource(), (GameProfile)class_2191.method_9330((CommandContext)context, (String)"target").iterator().next()))));
    }

    private static int executeInvSee(class_2168 source, GameProfile targetProfile) throws CommandSyntaxException {
        class_2561 screenTitle;
        Object dummyPlayer;
        class_1661 actualTargetInventory;
        class_3222 viewer = source.method_9207();
        class_3222 targetOnline = source.method_9211().method_3760().method_14602(targetProfile.getId());
        class_5455 registryLookup = source.method_30497();
        MinecraftServer server = source.method_9211();
        class_1277 displayInventory = new class_1277(45);
        class_1799 placeholder = new class_1799((class_1935)class_1802.field_8871);
        placeholder.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)" "));
        UUID targetUuid = targetProfile.getId();
        class_2487[] originalPlayerData = new class_2487[1];
        if (targetOnline != null) {
            actualTargetInventory = targetOnline.method_31548();
            dummyPlayer = targetOnline;
            screenTitle = targetOnline.method_5477();
        } else {
            class_2520 equipmentElement;
            class_2487 class_24872 = OfflinePlayerUtil.getOfflinePlayerData(server, targetProfile.getName());
            if (class_24872 == null) {
                throw OFFLINE_PLAYER_NOT_FOUND.create();
            }
            originalPlayerData[0] = class_24872.method_10553();
            screenTitle = class_2561.method_43470((String)(targetProfile.getName() + "'s Inventory"));
            dummyPlayer = new class_1657((class_1937)server.method_30002(), targetProfile){

                public boolean method_7325() {
                    return false;
                }

                public boolean method_68878() {
                    return false;
                }

                public boolean method_5681() {
                    return false;
                }

                public boolean method_5675() {
                    return false;
                }

                public boolean method_31747() {
                    return false;
                }

                public void method_6078(class_1282 source) {
                }

                public int method_6110(class_3218 world) {
                    return 0;
                }

                public class_1934 method_68876() {
                    return class_1934.field_9215;
                }

                protected class_4095.class_5303<?> method_28306() {
                    return super.method_28306();
                }

                protected class_3414 method_6011(class_1282 source) {
                    return null;
                }

                protected class_3414 method_6002() {
                    return null;
                }
            };
            actualTargetInventory = dummyPlayer.method_31548();
            class_2520 inventoryElement = class_24872.method_10580("Inventory");
            if (inventoryElement instanceof class_2499) {
                class_2499 inventoryNbtList = (class_2499)inventoryElement;
                for (int i = 0; i < inventoryNbtList.size(); ++i) {
                    Optional itemTagOptional = inventoryNbtList.method_10602(i);
                    itemTagOptional.ifPresent(itemTag -> {
                        DataResult parseResult = class_11343.field_60354.parse((DynamicOps)class_2509.field_11560, itemTag);
                        parseResult.result().ifPresent(stackWithSlot -> {
                            int slot = stackWithSlot.comp_4211();
                            class_1799 stack = stackWithSlot.comp_4212();
                            if (NBT_ARMOR_SLOT_MAP.containsKey(slot)) {
                                actualTargetInventory.method_5447(NBT_ARMOR_SLOT_MAP.get(slot).intValue(), stack);
                            } else if (slot >= 0 && slot < 36) {
                                actualTargetInventory.method_5447(slot, stack);
                            }
                        });
                    });
                }
            }
            if ((equipmentElement = class_24872.method_10580("equipment")) instanceof class_2487) {
                class_2487 equipmentCompound = (class_2487)equipmentElement;
                HashMap<class_1304, String> equipmentSlotToNbtTag = new HashMap<class_1304, String>();
                equipmentSlotToNbtTag.put(class_1304.field_6169, "head");
                equipmentSlotToNbtTag.put(class_1304.field_6174, "chest");
                equipmentSlotToNbtTag.put(class_1304.field_6172, "legs");
                equipmentSlotToNbtTag.put(class_1304.field_6166, "feet");
                equipmentSlotToNbtTag.put(class_1304.field_6171, "offhand");
                for (Map.Entry entry : equipmentSlotToNbtTag.entrySet()) {
                    class_1304 equipmentSlot = (class_1304)entry.getKey();
                    String nbtTagName = (String)entry.getValue();
                    class_2520 itemElement = equipmentCompound.method_10580(nbtTagName);
                    if (!(itemElement instanceof class_2487)) continue;
                    class_2487 itemNbtCompound = (class_2487)itemElement;
                    DataResult itemStackResult = class_1799.field_24671.parse((DynamicOps)class_2509.field_11560, (Object)itemNbtCompound);
                    itemStackResult.result().ifPresent(itemStack -> {
                        switch (equipmentSlot) {
                            case field_6169: {
                                actualTargetInventory.method_5447(39, itemStack);
                                break;
                            }
                            case field_6174: {
                                actualTargetInventory.method_5447(38, itemStack);
                                break;
                            }
                            case field_6172: {
                                actualTargetInventory.method_5447(37, itemStack);
                                break;
                            }
                            case field_6166: {
                                actualTargetInventory.method_5447(36, itemStack);
                                break;
                            }
                            case field_6171: {
                                actualTargetInventory.method_5447(40, itemStack);
                                break;
                            }
                        }
                    });
                }
            }
        }
        PlayerViewingCommands.copyPlayerInventoryToDisplay(actualTargetInventory, displayInventory);
        for (int slot : PLACEHOLDER_SLOTS) {
            displayInventory.method_5447(slot, placeholder.method_7972());
        }
        class_1265 class_12652 = inventory -> PlayerViewingCommands.copyPlayerInventoryToDisplay(actualTargetInventory, displayInventory);
        class_747 factory = new class_747((arg_0, arg_1, arg_2) -> PlayerViewingCommands.lambda$executeInvSee$8(displayInventory, actualTargetInventory, targetUuid, server, targetOnline, (class_1657)dummyPlayer, class_12652, originalPlayerData, targetProfile, arg_0, arg_1, arg_2), screenTitle);
        viewer.method_17355((class_3908)factory);
        return 1;
    }

    private static void copyPlayerInventoryToDisplay(class_1661 playerInventory, class_1277 displayInventory) {
        int i;
        for (i = 0; i < displayInventory.method_5439(); ++i) {
            boolean isPlaceholderSlot = false;
            for (int pSlot : PLACEHOLDER_SLOTS) {
                if (i != pSlot) continue;
                isPlaceholderSlot = true;
                break;
            }
            if (isPlaceholderSlot) continue;
            displayInventory.method_5447(i, class_1799.field_8037);
        }
        for (i = 0; i < 36; ++i) {
            displayInventory.method_5447(i, playerInventory.method_5438(i).method_7972());
        }
        displayInventory.method_5447(36, playerInventory.method_5438(39).method_7972());
        displayInventory.method_5447(37, playerInventory.method_5438(38).method_7972());
        displayInventory.method_5447(38, playerInventory.method_5438(37).method_7972());
        displayInventory.method_5447(39, playerInventory.method_5438(36).method_7972());
        displayInventory.method_5447(40, playerInventory.method_5438(40).method_7972());
    }

    private static void synchronizeDisplayToTargetInventory(class_1277 displayInventory, class_1661 targetInventory, class_1657 targetPlayer) {
        for (int i = 0; i < 36; ++i) {
            targetInventory.method_5447(i, displayInventory.method_5438(i).method_7972());
        }
        targetPlayer.method_5673(class_1304.field_6169, displayInventory.method_5438(36).method_7972());
        targetPlayer.method_5673(class_1304.field_6174, displayInventory.method_5438(37).method_7972());
        targetPlayer.method_5673(class_1304.field_6172, displayInventory.method_5438(38).method_7972());
        targetPlayer.method_5673(class_1304.field_6166, displayInventory.method_5438(39).method_7972());
        targetPlayer.method_5673(class_1304.field_6171, displayInventory.method_5438(40).method_7972());
        targetInventory.method_5431();
    }

    private static int executeEndSee(class_2168 source, final GameProfile targetProfile) throws CommandSyntaxException {
        class_3222 viewer = source.method_9207();
        class_3222 targetOnline = source.method_9211().method_3760().method_14602(targetProfile.getId());
        class_5455 registryLookup = source.method_30497();
        final MinecraftServer server = source.method_9211();
        final UUID targetUuid = targetProfile.getId();
        if (targetOnline != null) {
            viewer.method_17355((class_3908)new class_747((syncId, playerInv, player) -> new class_1707(class_3917.field_17326, syncId, playerInv, (class_1263)targetOnline.method_7274(), 3), targetOnline.method_5477()));
        } else {
            final class_2487[] originalPlayerData = new class_2487[1];
            class_2487 loadedPlayerData = OfflinePlayerUtil.getOfflinePlayerData(server, targetProfile.getName());
            if (loadedPlayerData == null) {
                throw OFFLINE_PLAYER_NOT_FOUND.create();
            }
            originalPlayerData[0] = loadedPlayerData.method_10553();
            final class_1730 offlineEnderChest = new class_1730();
            class_2520 enderItemsElement = loadedPlayerData.method_10580("EnderItems");
            if (enderItemsElement instanceof class_2499) {
                class_2499 enderItemsNbtList = (class_2499)enderItemsElement;
                for (int i = 0; i < enderItemsNbtList.size(); ++i) {
                    Optional itemTagOptional = enderItemsNbtList.method_10602(i);
                    itemTagOptional.ifPresent(itemTag -> {
                        DataResult parseResult = class_11343.field_60354.parse((DynamicOps)class_2509.field_11560, itemTag);
                        parseResult.result().ifPresent(stackWithSlot -> offlineEnderChest.method_5447(stackWithSlot.comp_4211(), stackWithSlot.comp_4212()));
                    });
                }
            }
            viewer.method_17355((class_3908)new class_747((syncId, playerInv, player) -> new class_1707(class_3917.field_17326, syncId, playerInv, (class_1263)offlineEnderChest, 3){

                public boolean method_7597(class_1657 playerEntity) {
                    return true;
                }

                public void method_7595(class_1657 playerEntity) {
                    super.method_7595(playerEntity);
                    class_2487 playerDataToSave = originalPlayerData[0];
                    ArrayList<class_11343> enderChestStacksToSave = new ArrayList<class_11343>();
                    for (int i = 0; i < offlineEnderChest.method_5439(); ++i) {
                        class_1799 stack = offlineEnderChest.method_5438(i);
                        if (stack.method_7960()) continue;
                        enderChestStacksToSave.add(new class_11343(i, stack));
                    }
                    DataResult writeResult = class_11343.field_60354.listOf().encodeStart((DynamicOps)class_2509.field_11560, enderChestStacksToSave);
                    writeResult.result().ifPresent(nbtElement -> playerDataToSave.method_10566("EnderItems", (class_2520)((class_2499)nbtElement)));
                    if (!OfflinePlayerUtil.saveOfflinePlayerData(playerDataToSave, targetUuid, server)) {
                        playerEntity.method_7353((class_2561)class_2561.method_43470((String)("Failed to save ender chest for offline player " + targetProfile.getName())), false);
                    } else {
                        playerEntity.method_7353((class_2561)class_2561.method_43470((String)("Saved ender chest for offline player " + targetProfile.getName())), false);
                    }
                }
            }, (class_2561)class_2561.method_43470((String)(targetProfile.getName() + "'s Ender Chest"))));
        }
        return 1;
    }

    private static /* synthetic */ class_1703 lambda$executeInvSee$8(final class_1277 displayInventory, final class_1661 actualTargetInventory, final UUID targetUuid, final MinecraftServer server, final class_3222 targetOnline, final class_1657 dummyPlayer, final class_1265 inventoryChangeListener, final class_2487[] originalPlayerData, final GameProfile targetProfile, int syncId, class_1661 playerInv, class_1657 player) {
        class_1707 handler = new class_1707(class_3917.field_18667, syncId, playerInv, (class_1263)displayInventory, 5){
            private final class_1661 targetInventoryRef;
            private final UUID invTargetUuid;
            private final MinecraftServer serverRef;
            private final class_3222 actualTargetOnlinePlayer;
            private final class_1657 targetPlayerEntity;
            {
                super(type, syncId, playerInventory, inventory, rows);
                this.targetInventoryRef = actualTargetInventory;
                this.invTargetUuid = targetUuid;
                this.serverRef = server;
                this.actualTargetOnlinePlayer = targetOnline;
                this.targetPlayerEntity = dummyPlayer;
            }

            public boolean method_7597(class_1657 playerEntity) {
                return true;
            }

            public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 playerEntity) {
                if (actionType == class_1713.field_7789) {
                    return;
                }
                if (slotIndex >= 0 && slotIndex < this.field_7761.size() - 36) {
                    for (int pSlot : PLACEHOLDER_SLOTS) {
                        if (slotIndex != pSlot) continue;
                        return;
                    }
                    super.method_7593(slotIndex, button, actionType, playerEntity);
                    PlayerViewingCommands.synchronizeDisplayToTargetInventory(displayInventory, this.targetInventoryRef, this.targetPlayerEntity);
                    this.targetInventoryRef.method_5431();
                    PlayerViewingCommands.copyPlayerInventoryToDisplay(this.targetInventoryRef, displayInventory);
                    this.method_7623();
                    if (this.actualTargetOnlinePlayer != null) {
                        this.actualTargetOnlinePlayer.method_31548().method_5431();
                        if (this.actualTargetOnlinePlayer.field_7512 != null) {
                            this.actualTargetOnlinePlayer.field_7512.method_7623();
                        }
                    }
                    return;
                }
                super.method_7593(slotIndex, button, actionType, playerEntity);
            }

            public void method_7595(class_1657 playerEntity) {
                super.method_7595(playerEntity);
                if (this.actualTargetOnlinePlayer != null && this.actualTargetOnlinePlayer.method_31548() instanceof IPlayerInventoryListener) {
                    ((IPlayerInventoryListener)this.actualTargetOnlinePlayer.method_31548()).basicsmodplus$removeListener(inventoryChangeListener);
                }
                if (this.actualTargetOnlinePlayer == null) {
                    class_1799 stack;
                    int i;
                    class_2487 playerDataToSave = originalPlayerData[0];
                    ArrayList<class_11343> playerStacksToSave = new ArrayList<class_11343>();
                    for (i = 0; i < 36; ++i) {
                        stack = this.targetInventoryRef.method_5438(i);
                        if (stack.method_7960()) continue;
                        playerStacksToSave.add(new class_11343(i, stack));
                    }
                    for (i = 36; i <= 39; ++i) {
                        stack = this.targetInventoryRef.method_5438(i);
                        if (stack.method_7960()) continue;
                        playerStacksToSave.add(new class_11343(i, stack));
                    }
                    DataResult writeResult = class_11343.field_60354.listOf().encodeStart((DynamicOps)class_2509.field_11560, playerStacksToSave);
                    writeResult.result().ifPresent(nbtElement -> playerDataToSave.method_10566("Inventory", (class_2520)((class_2499)nbtElement)));
                    class_2487 equipmentCompoundToSave = new class_2487();
                    class_2520 existingEquipmentElement = originalPlayerData[0].method_10580("equipment");
                    if (existingEquipmentElement instanceof class_2487) {
                        class_2487 existingEquipmentCompound = (class_2487)existingEquipmentElement;
                        equipmentCompoundToSave.method_10543(existingEquipmentCompound);
                    }
                    HashMap<class_1304, String> equipmentSlotToNbtTag = new HashMap<class_1304, String>();
                    equipmentSlotToNbtTag.put(class_1304.field_6169, "head");
                    equipmentSlotToNbtTag.put(class_1304.field_6174, "chest");
                    equipmentSlotToNbtTag.put(class_1304.field_6172, "legs");
                    equipmentSlotToNbtTag.put(class_1304.field_6166, "feet");
                    equipmentSlotToNbtTag.put(class_1304.field_6171, "offhand");
                    for (Map.Entry entry : equipmentSlotToNbtTag.entrySet()) {
                        class_1304 slot = (class_1304)entry.getKey();
                        String tagName = (String)entry.getValue();
                        class_1799 equippedStack = this.targetPlayerEntity.method_6118(slot);
                        if (!equippedStack.method_7960()) {
                            DataResult itemSaveResult = class_1799.field_24671.encodeStart((DynamicOps)class_2509.field_11560, (Object)equippedStack);
                            itemSaveResult.result().ifPresent(nbtElement -> {
                                if (nbtElement instanceof class_2487) {
                                    class_2487 itemNbt = (class_2487)nbtElement;
                                    equipmentCompoundToSave.method_10566(tagName, (class_2520)itemNbt);
                                }
                            });
                            continue;
                        }
                        equipmentCompoundToSave.method_10551(tagName);
                    }
                    if (!equipmentCompoundToSave.method_33133()) {
                        playerDataToSave.method_10566("equipment", (class_2520)equipmentCompoundToSave);
                    } else {
                        playerDataToSave.method_10551("equipment");
                    }
                    if (!OfflinePlayerUtil.saveOfflinePlayerData(playerDataToSave, this.invTargetUuid, this.serverRef)) {
                        playerEntity.method_7353((class_2561)class_2561.method_43470((String)("Failed to save inventory for offline player " + targetProfile.getName())), false);
                    } else {
                        playerEntity.method_7353((class_2561)class_2561.method_43470((String)("Saved inventory for offline player " + targetProfile.getName())), false);
                    }
                }
            }
        };
        if (targetOnline != null && targetOnline.method_31548() instanceof IPlayerInventoryListener) {
            ((IPlayerInventoryListener)targetOnline.method_31548()).basicsmodplus$addListener(inventoryChangeListener);
        }
        return handler;
    }

    static {
        NBT_ARMOR_SLOT_MAP.put(9, 39);
        NBT_ARMOR_SLOT_MAP.put(28, 38);
        NBT_ARMOR_SLOT_MAP.put(29, 37);
        NBT_ARMOR_SLOT_MAP.put(30, 36);
    }
}

