/*
 * Decompiled with CFR 0.152.
 */
package me.andy.basicsmodplus.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.andy.basicsmodplus.Basicsmodplus;
import me.andy.basicsmodplus.config.ConfigDataPlus;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfigPlus {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE_NAME = "main_configplus.json";
    private static File configFile;
    private static ConfigDataPlus currentConfig;

    public static void initialize() {
        Path modConfigDir = FabricLoader.getInstance().getConfigDir().resolve("basicsmod");
        try {
            Files.createDirectories(modConfigDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            Basicsmodplus.LOGGER.error("Failed to create config directory for BasicsModPlus.", (Throwable)e);
        }
        configFile = modConfigDir.resolve(CONFIG_FILE_NAME).toFile();
        ModConfigPlus.loadConfig();
    }

    public static ConfigDataPlus getConfig() {
        if (currentConfig == null) {
            ModConfigPlus.loadConfig();
        }
        return currentConfig;
    }

    public static void loadConfig() {
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                currentConfig = (ConfigDataPlus)GSON.fromJson((Reader)reader, ConfigDataPlus.class);
                if (currentConfig == null || currentConfig.repair() == null) {
                    currentConfig = ConfigDataPlus.createDefault();
                    ModConfigPlus.saveConfig();
                }
            }
            catch (Exception e) {
                Basicsmodplus.LOGGER.error("Failed to load BasicsModPlus config file. Using default values.", (Throwable)e);
                currentConfig = ConfigDataPlus.createDefault();
            }
        } else {
            currentConfig = ConfigDataPlus.createDefault();
            ModConfigPlus.saveConfig();
        }
    }

    public static void saveConfig() {
        if (currentConfig == null) {
            currentConfig = ConfigDataPlus.createDefault();
        }
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)currentConfig, (Appendable)writer);
        }
        catch (IOException e) {
            Basicsmodplus.LOGGER.error("Failed to save BasicsModPlus config file.", (Throwable)e);
        }
    }
}

