/*
 * Decompiled with CFR 0.152.
 */
package me.andy.basicsmodplus.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.andy.basicsmodplus.Basicsmodplus;
import me.andy.basicsmodplus.data.PlayerDataPlus;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3222;

public class UserInfoManagerPlus {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "player_data_plus.json";
    private static File configFile;
    private static ConcurrentHashMap<UUID, PlayerDataPlus> userInfoMap;

    public static void initialize() {
        Path modConfigDir = FabricLoader.getInstance().getConfigDir().resolve("basicsmod");
        try {
            Files.createDirectories(modConfigDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            Basicsmodplus.LOGGER.error("Failed to create config directory for BasicsModPlus.", (Throwable)e);
        }
        configFile = modConfigDir.resolve(FILE_NAME).toFile();
        UserInfoManagerPlus.load();
    }

    public static void load() {
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                Type type = new TypeToken<ConcurrentHashMap<UUID, PlayerDataPlus>>(){}.getType();
                userInfoMap = (ConcurrentHashMap)GSON.fromJson((Reader)reader, type);
                if (userInfoMap == null) {
                    userInfoMap = new ConcurrentHashMap();
                }
            }
            catch (Exception e) {
                Basicsmodplus.LOGGER.error("Failed to load BasicsModPlus player data file.", (Throwable)e);
                userInfoMap = new ConcurrentHashMap();
            }
        } else {
            userInfoMap = new ConcurrentHashMap();
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson(userInfoMap, (Appendable)writer);
        }
        catch (IOException e) {
            Basicsmodplus.LOGGER.error("Failed to save BasicsModPlus player data file.", (Throwable)e);
        }
    }

    public static PlayerDataPlus getPlayerData(UUID playerUuid) {
        return userInfoMap.computeIfAbsent(playerUuid, PlayerDataPlus::createDefault);
    }

    public static PlayerDataPlus getPlayerData(class_3222 player) {
        return UserInfoManagerPlus.getPlayerData(player.method_5667());
    }

    public static void updatePlayerData(PlayerDataPlus playerData) {
        if (playerData != null && playerData.playerUuid() != null) {
            userInfoMap.put(playerData.playerUuid(), playerData);
        }
    }

    static {
        userInfoMap = new ConcurrentHashMap();
    }
}

