/*
 * Decompiled with CFR 0.152.
 */
package me.andy.basicsmodplus.util;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class CooldownManager {
    private static final Map<UUID, Map<String, Long>> cooldowns = new ConcurrentHashMap<UUID, Map<String, Long>>();

    public static void setCooldown(UUID playerUuid, String commandKey, int cooldownMinutes) {
        if (cooldownMinutes <= 0) {
            return;
        }
        long cooldownMillis = (long)cooldownMinutes * 60L * 1000L;
        long expirationTime = System.currentTimeMillis() + cooldownMillis;
        cooldowns.computeIfAbsent(playerUuid, k -> new ConcurrentHashMap()).put(commandKey, expirationTime);
    }

    public static boolean isOnCooldown(UUID playerUuid, String commandKey) {
        Map<String, Long> playerCooldowns = cooldowns.get(playerUuid);
        if (playerCooldowns == null || !playerCooldowns.containsKey(commandKey)) {
            return false;
        }
        long expirationTime = playerCooldowns.get(commandKey);
        if (System.currentTimeMillis() < expirationTime) {
            return true;
        }
        playerCooldowns.remove(commandKey);
        if (playerCooldowns.isEmpty()) {
            cooldowns.remove(playerUuid);
        }
        return false;
    }

    public static String getRemainingCooldown(UUID playerUuid, String commandKey) {
        if (!CooldownManager.isOnCooldown(playerUuid, commandKey)) {
            return "";
        }
        long expirationTime = cooldowns.get(playerUuid).get(commandKey);
        long remainingMillis = expirationTime - System.currentTimeMillis();
        if (remainingMillis <= 0L) {
            return "";
        }
        long totalSeconds = remainingMillis / 1000L;
        long minutes = totalSeconds / 60L;
        long seconds = totalSeconds % 60L;
        return String.format("%dm %ds", minutes, seconds);
    }
}

