/*
 * Decompiled with CFR 0.152.
 */
package me.andy.basicsmodplus.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.andy.basicsmodplus.Basicsmodplus;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class MessageFormatter {
    private static final Pattern TOKENIZER_PATTERN = Pattern.compile("(?:&#([0-9a-fA-F]{6}))|(?:&([0-9a-fk-orA-FK-OR]))|(\\{(.*?)\\})|(<action:(\\w+),([^>]*?)>)|([^&{<]+)");

    public static List<class_2561> formatLines(List<String> rawLines, @Nullable class_3222 player, @Nullable MinecraftServer server) {
        ArrayList<class_2561> formattedTexts = new ArrayList<class_2561>();
        if (rawLines == null) {
            return formattedTexts;
        }
        for (String rawLine : rawLines) {
            if (rawLine == null) {
                formattedTexts.add((class_2561)class_2561.method_43473());
                continue;
            }
            formattedTexts.add((class_2561)MessageFormatter.parseSingleLine(rawLine, player, server, false));
        }
        return formattedTexts;
    }

    private static class_5250 parseSingleLine(String rawLine, @Nullable class_3222 player, @Nullable MinecraftServer server, boolean isHover) {
        class_5250 baseComponent = class_2561.method_43470((String)"");
        if (rawLine == null || rawLine.isEmpty()) {
            return baseComponent;
        }
        Matcher matcher = TOKENIZER_PATTERN.matcher(rawLine);
        class_2583 currentStyle = class_2583.field_24360;
        class_5250 lastTextSegment = null;
        while (matcher.find()) {
            String hexColor = matcher.group(1);
            String vanillaCode = matcher.group(2);
            String hoverContent = matcher.group(4);
            String actionType = matcher.group(6);
            String actionValue = matcher.group(7);
            String plainText = matcher.group(8);
            if (hexColor != null) {
                try {
                    currentStyle = currentStyle.method_27703((class_5251)class_5251.method_27719((String)("#" + hexColor)).getOrThrow());
                }
                catch (Exception e) {
                    Basicsmodplus.LOGGER.warn("Invalid hex color code: {}", (Object)hexColor, (Object)e);
                }
                continue;
            }
            if (vanillaCode != null) {
                char codeChar = vanillaCode.toLowerCase().charAt(0);
                if (codeChar == 'r') {
                    currentStyle = class_2583.field_24360;
                    continue;
                }
                class_124 mcFormatting = class_124.method_544((char)codeChar);
                if (mcFormatting == null) continue;
                currentStyle = MessageFormatter.applyMinecraftFormatting(currentStyle, mcFormatting);
                continue;
            }
            if (hoverContent != null && !isHover && lastTextSegment != null) {
                class_5250 hoverText = MessageFormatter.parseSingleLine(hoverContent, player, server, true);
                lastTextSegment.method_10862(lastTextSegment.method_10866().method_10949((class_2568)new class_2568.class_10613((class_2561)hoverText)));
                continue;
            }
            if (actionType != null && actionValue != null && !isHover && lastTextSegment != null) {
                class_2558 clickEvent = MessageFormatter.createClickEvent(actionType, actionValue);
                if (clickEvent == null) continue;
                lastTextSegment.method_10862(lastTextSegment.method_10866().method_10958(clickEvent));
                continue;
            }
            if (plainText == null) continue;
            class_5250 segment = class_2561.method_43470((String)plainText).method_10862(currentStyle);
            baseComponent.method_10852((class_2561)segment);
            lastTextSegment = segment;
        }
        return baseComponent;
    }

    private static class_2558 createClickEvent(String actionType, String value) {
        return switch (actionType.toLowerCase().trim()) {
            case "open_url" -> {
                try {
                    if (!((String)value).matches("^(https?|ftp)://.*")) {
                        value = "http://" + (String)value;
                    }
                    URI uri = new URI((String)value);
                    class_2558.class_10608 var4_6 = new class_2558.class_10608(uri);
                    yield var4_6;
                }
                catch (URISyntaxException e) {
                    Basicsmodplus.LOGGER.warn("Invalid URI for open_url action: {}", value, (Object)e);
                    Object var4_7 = null;
                    yield var4_7;
                }
            }
            case "run_command" -> {
                class_2558.class_10609 var4_8;
                yield var4_8 = new class_2558.class_10609((String)value);
            }
            case "suggest_command" -> {
                class_2558.class_10610 var4_9 = new class_2558.class_10610((String)value);
                yield var4_9;
            }
            case "copy_to_clipboard" -> {
                class_2558.class_10606 var4_10 = new class_2558.class_10606((String)value);
                yield var4_10;
            }
            default -> {
                Basicsmodplus.LOGGER.warn("Unknown click action type: {}", (Object)actionType);
                Object var4_11 = null;
                yield var4_11;
            }
        };
    }

    private static class_2583 applyMinecraftFormatting(class_2583 style, class_124 formatting) {
        if (formatting.method_543()) {
            return style.method_10977(formatting);
        }
        if (formatting.method_542()) {
            return switch (formatting) {
                case class_124.field_1051 -> style.method_36141(Boolean.valueOf(true));
                case class_124.field_1067 -> style.method_10982(Boolean.valueOf(true));
                case class_124.field_1055 -> style.method_36140(Boolean.valueOf(true));
                case class_124.field_1073 -> style.method_30938(Boolean.valueOf(true));
                case class_124.field_1056 -> style.method_10978(Boolean.valueOf(true));
                default -> style;
            };
        }
        return style;
    }
}

