/*
 * Decompiled with CFR 0.152.
 */
package me.andy.basicsmodplus.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Arrays;
import java.util.List;
import me.andy.basicsmodplus.util.PermissionLevelUtil;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_1934;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class GamemodeCommands {
    private static final String PERM_GAMEMODE = "basicsmod.gamemode";
    private static final String PERM_GAMEMODE_OTHERS = "basicsmod.gamemode.others";
    private static final SimpleCommandExceptionType INVALID_GAMEMODE = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Invalid gamemode specified."));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        List<String> gamemodeSuggestions = Arrays.asList("survival", "s", "su", "0", "creative", "c", "cr", "1", "adventure", "a", "ad", "2", "spectator", "sp", "3");
        LiteralArgumentBuilder gmCommandBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"gm").requires(source -> Permissions.check((class_2172)source, (String)"basicsmod.gamemode.survival", (int)2) || Permissions.check((class_2172)source, (String)"basicsmod.gamemode.creative", (int)2) || Permissions.check((class_2172)source, (String)"basicsmod.gamemode.adventure", (int)2) || Permissions.check((class_2172)source, (String)"basicsmod.gamemode.spectator", (int)2) || Permissions.check((class_2172)source, (String)"basicsmod.gamemode.*", (int)2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"gamemode", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265((Iterable)gamemodeSuggestions, (SuggestionsBuilder)builder)).executes(context -> GamemodeCommands.executeGamemode((CommandContext<class_2168>)context, null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).requires(source -> Permissions.check((class_2172)source, (String)PERM_GAMEMODE_OTHERS, (int)2))).executes(context -> GamemodeCommands.executeGamemode((CommandContext<class_2168>)context, class_2186.method_9315((CommandContext)context, (String)"target")))));
        LiteralCommandNode gmNode = dispatcher.register(gmCommandBuilder);
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"gamemode").redirect((CommandNode)gmNode));
    }

    private static int executeGamemode(CommandContext<class_2168> context, class_3222 target) throws CommandSyntaxException {
        class_1934 gameMode;
        String gmArg = StringArgumentType.getString(context, (String)"gamemode").toLowerCase();
        class_3222 sourcePlayer = ((class_2168)context.getSource()).method_9207();
        class_3222 targetPlayer = target == null ? sourcePlayer : target;
        boolean isSelf = targetPlayer.equals((Object)sourcePlayer);
        switch (gmArg) {
            case "survival": 
            case "s": 
            case "su": 
            case "0": {
                class_1934 class_19342 = class_1934.field_9215;
                break;
            }
            case "creative": 
            case "c": 
            case "cr": 
            case "1": {
                class_1934 class_19342 = class_1934.field_9220;
                break;
            }
            case "adventure": 
            case "a": 
            case "ad": 
            case "2": {
                class_1934 class_19342 = class_1934.field_9216;
                break;
            }
            case "spectator": 
            case "sp": 
            case "3": {
                class_1934 class_19342 = class_1934.field_9219;
                break;
            }
            default: {
                class_1934 class_19342 = gameMode = null;
            }
        }
        if (gameMode == null) {
            throw INVALID_GAMEMODE.create();
        }
        if (!isSelf && !Permissions.check((class_2172)((class_2172)context.getSource()), (String)PERM_GAMEMODE_OTHERS, (int)2)) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You do not have permission to change other players' game modes."));
            return 0;
        }
        String specificPerm = "basicsmod.gamemode." + gameMode.method_15434();
        if (!(Permissions.check((class_2172)((class_2172)context.getSource()), (String)specificPerm, (int)2) || Permissions.check((class_2172)((class_2172)context.getSource()), (String)"basicsmod.gamemode.*", (int)2) || PermissionLevelUtil.checkPermissionLevel((class_2168)context.getSource(), 2))) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You do not have permission to switch to this game mode."));
            return 0;
        }
        targetPlayer.method_7336(gameMode);
        class_5250 feedback = isSelf ? class_2561.method_43470((String)"Set own game mode to ").method_10852((class_2561)class_2561.method_43470((String)gameMode.method_15434()).method_27692(class_124.field_1054)) : class_2561.method_43470((String)"Set game mode of ").method_10852(targetPlayer.method_5477()).method_27693(" to ").method_10852((class_2561)class_2561.method_43470((String)gameMode.method_15434()).method_27692(class_124.field_1054));
        ((class_2168)context.getSource()).method_9226(() -> GamemodeCommands.lambda$executeGamemode$5((class_2561)feedback), true);
        return 1;
    }

    private static /* synthetic */ class_2561 lambda$executeGamemode$5(class_2561 feedback) {
        return feedback;
    }
}

