/*
 * Decompiled with CFR 0.152.
 */
package me.andy.basicsmodplus.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import me.andy.basicsmodplus.util.MessageFormatter;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class ItemEditingCommands {
    private static final String PERM_ITEMEDIT = "basicsmod.itemedit";
    private static final String PERM_ANVIL_COLOR = "basicsmod.anvil.color";

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"itemedit").requires(source -> Permissions.check((class_2172)source, (String)PERM_ITEMEDIT, (int)2))).then(class_2170.method_9247((String)"name").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> ItemEditingCommands.executeName((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lore").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> ItemEditingCommands.executeLoreAdd((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"text")))))).then(class_2170.method_9247((String)"clear").executes(ctx -> ItemEditingCommands.executeLoreClear((class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"setline").then(class_2170.method_9244((String)"line", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> ItemEditingCommands.executeLoreSet((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"line"), StringArgumentType.getString((CommandContext)ctx, (String)"text"))))))).then(class_2170.method_9247((String)"remline").then(class_2170.method_9244((String)"line", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ItemEditingCommands.executeLoreRemove((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"line"))))))).then(class_2170.method_9247((String)"glint").executes(ctx -> ItemEditingCommands.executeGlint((class_2168)ctx.getSource()))));
    }

    private static int executeName(class_2168 source, String name) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        class_1799 stack = player.method_6047();
        if (stack.method_7960()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You must be holding an item.").method_27692(class_124.field_1061));
            return 0;
        }
        class_2561 formattedName = MessageFormatter.formatLines(List.of(name), player, source.method_9211()).get(0);
        stack.method_57379(class_9334.field_49631, (Object)formattedName);
        source.method_9226(() -> class_2561.method_43470((String)"Item name set.").method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int executeGlint(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        class_1799 stack = player.method_6047();
        if (stack.method_7960()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You must be holding an item.").method_27692(class_124.field_1061));
            return 0;
        }
        boolean hasGlint = stack.method_58694(class_9334.field_49641) != null && (Boolean)stack.method_58694(class_9334.field_49641) != false;
        stack.method_57379(class_9334.field_49641, (Object)(!hasGlint ? 1 : 0));
        source.method_9226(() -> class_2561.method_43470((String)("Glint effect " + (!hasGlint ? "added." : "removed."))).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int executeLoreAdd(class_2168 source, String text) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        class_1799 stack = player.method_6047();
        if (stack.method_7960()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You must be holding an item.").method_27692(class_124.field_1061));
            return 0;
        }
        class_9290 currentLore = (class_9290)stack.method_58695(class_9334.field_49632, (Object)class_9290.field_49340);
        ArrayList<class_2561> newLoreLines = new ArrayList<class_2561>(currentLore.comp_2400());
        newLoreLines.add(MessageFormatter.formatLines(List.of(text), player, source.method_9211()).get(0));
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(newLoreLines));
        source.method_9226(() -> class_2561.method_43470((String)"Lore added.").method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int executeLoreClear(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        class_1799 stack = player.method_6047();
        if (stack.method_7960()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You must be holding an item.").method_27692(class_124.field_1061));
            return 0;
        }
        stack.method_57381(class_9334.field_49632);
        source.method_9226(() -> class_2561.method_43470((String)"Lore cleared.").method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int executeLoreSet(class_2168 source, int line, String text) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        class_1799 stack = player.method_6047();
        if (stack.method_7960()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You must be holding an item.").method_27692(class_124.field_1061));
            return 0;
        }
        class_9290 currentLore = (class_9290)stack.method_58695(class_9334.field_49632, (Object)class_9290.field_49340);
        ArrayList<class_2561> newLoreLines = new ArrayList<class_2561>(currentLore.comp_2400());
        int lineIndex = line - 1;
        if (lineIndex < 0 || lineIndex >= newLoreLines.size()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Invalid line number.").method_27692(class_124.field_1061));
            return 0;
        }
        newLoreLines.set(lineIndex, MessageFormatter.formatLines(List.of(text), player, source.method_9211()).get(0));
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(newLoreLines));
        source.method_9226(() -> class_2561.method_43470((String)("Lore line " + line + " set.")).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int executeLoreRemove(class_2168 source, int line) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        class_1799 stack = player.method_6047();
        if (stack.method_7960()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You must be holding an item.").method_27692(class_124.field_1061));
            return 0;
        }
        class_9290 currentLore = (class_9290)stack.method_58695(class_9334.field_49632, (Object)class_9290.field_49340);
        ArrayList newLoreLines = new ArrayList(currentLore.comp_2400());
        int lineIndex = line - 1;
        if (lineIndex < 0 || lineIndex >= newLoreLines.size()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Invalid line number.").method_27692(class_124.field_1061));
            return 0;
        }
        newLoreLines.remove(lineIndex);
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(newLoreLines));
        source.method_9226(() -> class_2561.method_43470((String)("Lore line " + line + " removed.")).method_27692(class_124.field_1060), false);
        return 1;
    }

    public static void basicsmodplus$setAnvilItemName(class_3222 player, class_1799 stack, class_2561 formattedName) {
        stack.method_57379(class_9334.field_49631, (Object)formattedName);
    }
}

