/*
 * Decompiled with CFR 0.152.
 */
package me.andy.basicsmodplus.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import me.andy.basicsmodplus.api.IPlayerInventoryListener;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_11560;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_747;
import net.minecraft.class_9334;

public class PlayerViewingCommands {
    private static final String PERM_INVSEE = "basicsmod.invsee";
    private static final String PERM_ENDSEE = "basicsmod.endsee";
    private static final int[] PLACEHOLDER_SLOTS = new int[]{41, 42, 43, 44};

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"invsee").requires(source -> Permissions.check((class_2172)source, (String)PERM_INVSEE, (int)3))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2191.method_9329()).executes(context -> {
            Collection profiles = class_2191.method_9330((CommandContext)context, (String)"target");
            if (profiles.isEmpty()) {
                throw new RuntimeException("No profiles found");
            }
            class_11560 entry = (class_11560)profiles.iterator().next();
            GameProfile profile = new GameProfile(entry.comp_4422(), entry.comp_4423());
            return PlayerViewingCommands.executeInvSee((class_2168)context.getSource(), profile);
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"endsee").requires(source -> Permissions.check((class_2172)source, (String)PERM_ENDSEE, (int)3))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2191.method_9329()).executes(context -> {
            Collection profiles = class_2191.method_9330((CommandContext)context, (String)"target");
            if (profiles.isEmpty()) {
                throw new RuntimeException("No profiles found");
            }
            class_11560 entry = (class_11560)profiles.iterator().next();
            GameProfile profile = new GameProfile(entry.comp_4422(), entry.comp_4423());
            return PlayerViewingCommands.executeEndSee((class_2168)context.getSource(), profile);
        })));
    }

    private static int executeInvSee(class_2168 source, GameProfile targetProfile) throws CommandSyntaxException {
        class_3222 viewer = source.method_9207();
        final class_3222 targetOnline = source.method_9211().method_3760().method_14602(targetProfile.id());
        if (targetOnline == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"That player is not currently online.").method_27692(class_124.field_1061));
            return 0;
        }
        final class_1277 displayInventory = new class_1277(45);
        class_1799 placeholder = new class_1799((class_1935)class_1802.field_8871);
        placeholder.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)" "));
        final class_1661 actualTargetInventory = targetOnline.method_31548();
        class_2561 screenTitle = targetOnline.method_5477();
        PlayerViewingCommands.copyPlayerInventoryToDisplay(actualTargetInventory, displayInventory);
        for (int slot : PLACEHOLDER_SLOTS) {
            displayInventory.method_5447(slot, placeholder.method_7972());
        }
        final class_1265 inventoryChangeListener = inventory -> PlayerViewingCommands.copyPlayerInventoryToDisplay(actualTargetInventory, displayInventory);
        class_747 factory = new class_747((syncId, playerInv, player) -> {
            class_1707 handler = new class_1707(class_3917.field_18667, syncId, playerInv, (class_1263)displayInventory, 5){
                private final class_1661 targetInventoryRef;
                private final class_3222 actualTargetOnlinePlayer;
                {
                    super(arg0, arg1, arg2, arg3, arg4);
                    this.targetInventoryRef = actualTargetInventory;
                    this.actualTargetOnlinePlayer = targetOnline;
                }

                public boolean method_7597(class_1657 playerEntity) {
                    return true;
                }

                public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 playerEntity) {
                    if (actionType == class_1713.field_7789) {
                        return;
                    }
                    if (slotIndex >= 0 && slotIndex < this.field_7761.size() - 36) {
                        for (int pSlot : PLACEHOLDER_SLOTS) {
                            if (slotIndex != pSlot) continue;
                            return;
                        }
                        super.method_7593(slotIndex, button, actionType, playerEntity);
                        PlayerViewingCommands.synchronizeDisplayToTargetInventory(displayInventory, this.targetInventoryRef, (class_1657)this.actualTargetOnlinePlayer);
                        this.targetInventoryRef.method_5431();
                        PlayerViewingCommands.copyPlayerInventoryToDisplay(this.targetInventoryRef, displayInventory);
                        this.method_7623();
                        this.actualTargetOnlinePlayer.method_31548().method_5431();
                        if (this.actualTargetOnlinePlayer.field_7512 != null) {
                            this.actualTargetOnlinePlayer.field_7512.method_7623();
                        }
                        return;
                    }
                    super.method_7593(slotIndex, button, actionType, playerEntity);
                }

                public void method_7595(class_1657 playerEntity) {
                    super.method_7595(playerEntity);
                    if (this.actualTargetOnlinePlayer.method_31548() instanceof IPlayerInventoryListener) {
                        ((IPlayerInventoryListener)this.actualTargetOnlinePlayer.method_31548()).basicsmodplus$removeListener(inventoryChangeListener);
                    }
                }
            };
            if (targetOnline.method_31548() instanceof IPlayerInventoryListener) {
                ((IPlayerInventoryListener)targetOnline.method_31548()).basicsmodplus$addListener(inventoryChangeListener);
            }
            return handler;
        }, screenTitle);
        viewer.method_17355((class_3908)factory);
        return 1;
    }

    private static void copyPlayerInventoryToDisplay(class_1661 playerInventory, class_1277 displayInventory) {
        int i;
        for (i = 0; i < displayInventory.method_5439(); ++i) {
            boolean isPlaceholderSlot = false;
            for (int pSlot : PLACEHOLDER_SLOTS) {
                if (i != pSlot) continue;
                isPlaceholderSlot = true;
                break;
            }
            if (isPlaceholderSlot) continue;
            displayInventory.method_5447(i, class_1799.field_8037);
        }
        for (i = 0; i < 36; ++i) {
            displayInventory.method_5447(i, playerInventory.method_5438(i).method_7972());
        }
        displayInventory.method_5447(36, playerInventory.method_5438(39).method_7972());
        displayInventory.method_5447(37, playerInventory.method_5438(38).method_7972());
        displayInventory.method_5447(38, playerInventory.method_5438(37).method_7972());
        displayInventory.method_5447(39, playerInventory.method_5438(36).method_7972());
        displayInventory.method_5447(40, playerInventory.method_5438(40).method_7972());
    }

    private static void synchronizeDisplayToTargetInventory(class_1277 displayInventory, class_1661 targetInventory, class_1657 targetPlayer) {
        for (int i = 0; i < 36; ++i) {
            targetInventory.method_5447(i, displayInventory.method_5438(i).method_7972());
        }
        targetPlayer.method_5673(class_1304.field_6169, displayInventory.method_5438(36).method_7972());
        targetPlayer.method_5673(class_1304.field_6174, displayInventory.method_5438(37).method_7972());
        targetPlayer.method_5673(class_1304.field_6172, displayInventory.method_5438(38).method_7972());
        targetPlayer.method_5673(class_1304.field_6166, displayInventory.method_5438(39).method_7972());
        targetPlayer.method_5673(class_1304.field_6171, displayInventory.method_5438(40).method_7972());
        targetInventory.method_5431();
    }

    private static int executeEndSee(class_2168 source, GameProfile targetProfile) throws CommandSyntaxException {
        class_3222 viewer = source.method_9207();
        class_3222 targetOnline = source.method_9211().method_3760().method_14602(targetProfile.id());
        if (targetOnline != null) {
            viewer.method_17355((class_3908)new class_747((syncId, playerInv, player) -> new class_1707(class_3917.field_17326, syncId, playerInv, (class_1263)targetOnline.method_7274(), 3), targetOnline.method_5477()));
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"That player is not currently online.").method_27692(class_124.field_1061));
        return 0;
    }
}

