/*
 * Decompiled with CFR 0.152.
 */
package com.senne.chatInputAPI;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.senne.chatInputAPI.Metrics;
import com.senne.chatInputAPI.chatTextAPI.ChatHandler;
import com.senne.chatInputAPI.chatTextAPI.events.AsyncChatListener;
import com.senne.chatInputAPI.chatTextAPI.events.PlayerLeaveListener;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ChatInputAPIMain
extends JavaPlugin {
    private static JavaPlugin plugin;

    public static JavaPlugin getPlugin() {
        return plugin;
    }

    private static void setPlugin(JavaPlugin plugin) {
        ChatInputAPIMain.plugin = plugin;
    }

    public void onEnable() {
        int pluginId = 25493;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        ChatInputAPIMain.init(this);
    }

    public void onDisable() {
    }

    public static boolean init(JavaPlugin plugin) {
        if (ChatInputAPIMain.getPlugin() != null) {
            return false;
        }
        ChatInputAPIMain.setPlugin(plugin);
        plugin.getServer().getPluginManager().registerEvents((Listener)new AsyncChatListener(), (Plugin)plugin);
        plugin.getServer().getPluginManager().registerEvents((Listener)new PlayerLeaveListener(), (Plugin)plugin);
        LifecycleEventManager manager = plugin.getLifecycleManager();
        manager.registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            Commands commands = (Commands)event.registrar();
            LiteralArgumentBuilder cancel = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"chatinputcancel").requires(source -> {
                if (!(source.getSender() instanceof Player)) {
                    return false;
                }
                return ChatHandler.hasActiveChat((Player)source.getSender());
            })).executes(context -> {
                Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
                ChatHandler.runCancel(player);
                ChatHandler.removeActiveChat(player);
                return 1;
            });
            commands.getDispatcher().register(cancel);
        });
        return true;
    }
}

