/*
 * Decompiled with CFR 0.152.
 */
package com.senne.chatInputAPI;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.senne.chatInputAPI.chatTextAPI.ChatHandler;
import com.senne.chatInputAPI.chatTextAPI.events.AsyncChatListener;
import com.senne.chatInputAPI.chatTextAPI.events.PlayerLeaveListener;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ChatInputAPIMain
extends JavaPlugin {
    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)new AsyncChatListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerLeaveListener(), (Plugin)this);
        LifecycleEventManager manager = this.getLifecycleManager();
        manager.registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            Commands commands = (Commands)event.registrar();
            LiteralArgumentBuilder cancel = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"chatinputcancel").requires(source -> {
                if (!(source.getSender() instanceof Player)) {
                    return false;
                }
                return ChatHandler.hasActiveChat((Player)source.getSender());
            })).executes(context -> {
                Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
                ChatHandler.runCancel(player);
                ChatHandler.removeActiveChat(player);
                return 1;
            });
            commands.getDispatcher().register(cancel);
        });
    }

    public void onDisable() {
    }
}

