/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import io.github.kadir1243.rivalrebels.RRClient;
import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.command.CommandContinueRound;
import io.github.kadir1243.rivalrebels.common.command.CommandHotPotato;
import io.github.kadir1243.rivalrebels.common.command.CommandMotD;
import io.github.kadir1243.rivalrebels.common.command.CommandPassword;
import io.github.kadir1243.rivalrebels.common.command.CommandResetGame;
import io.github.kadir1243.rivalrebels.common.command.CommandRobot;
import io.github.kadir1243.rivalrebels.common.command.CommandStopRounds;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsGuiHandler;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import io.github.kadir1243.rivalrebels.common.entity.RhodesType;
import io.github.kadir1243.rivalrebels.common.entity.RhodesTypes;
import io.github.kadir1243.rivalrebels.common.entity.brain.Activities;
import io.github.kadir1243.rivalrebels.common.entity.brain.MemoryModuleTypes;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.item.components.RRComponents;
import io.github.kadir1243.rivalrebels.common.packet.PacketDispatcher;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsRound;
import io.github.kadir1243.rivalrebels.common.tileentity.RRTileEntities;
import io.github.kadir1243.rivalrebels.datagen.DataGen;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.slf4j.Logger;

@Mod(value="rivalrebels")
public class RivalRebels {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<EntityDataSerializer<?>> DATA_SERIALIZERS = DeferredRegister.create((Registry)NeoForgeRegistries.ENTITY_DATA_SERIALIZERS, (String)"rivalrebels");
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> ARGUMENT_TYPE_INFOS = DeferredRegister.create((ResourceKey)Registries.COMMAND_ARGUMENT_TYPE, (String)"rivalrebels");
    public static final ResourceKey<Registry<RhodesType>> RHODES_TYPE_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)RRIdentifiers.create("rhodes_type"));
    public static final Registry<RhodesType> RHODES_TYPE_REGISTRY = new RegistryBuilder(RHODES_TYPE_REGISTRY_KEY).defaultKey(RRIdentifiers.create("rhodes")).sync(true).create();
    public static final TagKey<Block> MINEABLE_WITH_ARMY_SHOVEL = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)RRIdentifiers.create("mineable/army_shovel"));
    public static final TagKey<Block> NUCLEAR_STONE_GENERATEABLE = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)RRIdentifiers.create("nuclear_stone_generateable"));
    public static final TagKey<Item> OMEGA_ARMOR = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)RRIdentifiers.create("armor/omega"));
    public static final TagKey<Item> SIGMA_ARMOR = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)RRIdentifiers.create("armor/sigma"));
    public static RivalRebelsRound round;

    public RivalRebels(IEventBus modEventBus, ModContainer modContainer, Dist dist) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RRConfig.SERVER_SPEC);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)RRConfig.CLIENT_SPEC);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)RRConfig.COMMON_SPEC);
        NeoForge.EVENT_BUS.addListener(RivalRebels::registerCommand);
        RRComponents.init(modEventBus);
        RhodesTypes.init(modEventBus);
        PacketDispatcher.init(modEventBus);
        NeoForge.EVENT_BUS.addListener(RivalRebels::serverStarted);
        round = new RivalRebelsRound();
        round.init(modEventBus, dist);
        RRSounds.init(modEventBus);
        RivalRebelsGuiHandler.init(modEventBus, dist);
        RivalRebelsDamageSource.RRDamageTypes.init();
        RRItems.init(modEventBus);
        RRBlocks.init(modEventBus, dist);
        RRTileEntities.init(modEventBus);
        Activities.init(modEventBus);
        MemoryModuleTypes.init(modEventBus);
        RREntities.init(modEventBus);
        DATA_SERIALIZERS.register(modEventBus);
        ARGUMENT_TYPE_INFOS.register(modEventBus);
        if (dist.isClient()) {
            RRClient.init(modEventBus);
            modEventBus.addListener(DataGen::onGatherClientData);
        }
        modEventBus.addListener(DataGen::onGatherServerData);
        modEventBus.addListener(NewRegistryEvent.class, event -> event.register(RHODES_TYPE_REGISTRY));
    }

    private static void serverStarted(ServerStartedEvent event) {
        round.setRoundDistances(RRConfig.SERVER.getSpawnDomeRadius(), RRConfig.SERVER.getTeleportDistance(), RRConfig.SERVER.getObjectiveDistance());
    }

    private static void registerCommand(RegisterCommandsEvent event) {
        CommandBuildContext context = event.getBuildContext();
        CommandDispatcher dispatcher = event.getDispatcher();
        CommandResetGame.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        CommandPassword.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        CommandStopRounds.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        CommandContinueRound.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        CommandMotD.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        CommandRobot.register((CommandDispatcher<CommandSourceStack>)dispatcher, context);
        CommandHotPotato.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    static {
        ARGUMENT_TYPE_INFOS.register("rhodes_type", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(CommandRobot.RhodesTypeArgumentType.class, (ArgumentTypeInfo)SingletonArgumentInfo.contextAware(CommandRobot.RhodesTypeArgumentType::argumentType)));
    }
}

