/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.gui;

import io.github.kadir1243.rivalrebels.RRClient;
import io.github.kadir1243.rivalrebels.client.guihelper.GuiFTKnob;
import io.github.kadir1243.rivalrebels.client.renderhelper.RRTextures;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.item.components.FlameThrowerMode;
import io.github.kadir1243.rivalrebels.common.item.components.RRComponents;
import io.github.kadir1243.rivalrebels.common.packet.ItemUpdate;
import io.github.kadir1243.rivalrebels.mixin.client.GuiGraphicsAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiFlameThrower
extends Screen {
    private final int xSizeOfTexture = 256;
    private final int ySizeOfTexture = 256;
    private int posX;
    private int posY;
    private GuiFTKnob knob;
    private final int start;

    public GuiFlameThrower(int start) {
        super((Component)Component.empty());
        this.start = start;
    }

    public void init() {
        this.posX = (this.width - 256) / 2;
        this.posY = (this.height - 256) / 2;
        this.knob = (GuiFTKnob)Button.builder((Component)Component.literal((String)"Knob"), button -> {}).bounds(this.posX + 108, this.posY + 176, 36, 36).build(builder -> new GuiFTKnob((Button.Builder)builder, this.start));
        this.addRenderableWidget((GuiEventListener)this.knob);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        float f = 0.00390625f;
        ((GuiGraphicsAccessor)context).blit(RenderPipelines.GUI_TEXTURED, RRTextures.guiflamethrower, this.posX, this.posX + 256, this.posY, this.posY + 256, 0.0f, 0.0f, 256.0f * f, 256.0f * f, 0);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (RRClient.USE_KEY.matches(keyCode, scanCode)) {
            this.onClose();
            this.minecraft.setWindowActive(true);
            ItemStack stack = this.minecraft.player.getMainHandItem();
            if (stack.isEmpty() || !stack.is(RRItems.flamethrower)) {
                return super.keyReleased(keyCode, scanCode, modifiers);
            }
            stack.set(RRComponents.FLAME_THROWER_MODE, (Object)new FlameThrowerMode(this.knob.getDegree()));
            Minecraft.getInstance().getConnection().send((CustomPacketPayload)new ItemUpdate(this.minecraft.player.getInventory().getSelectedSlot(), this.knob.getDegree()));
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }
}

