/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.gui;

import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.RivalRebels;
import io.github.kadir1243.rivalrebels.client.gui.GuiClass;
import io.github.kadir1243.rivalrebels.client.guihelper.GuiButton;
import io.github.kadir1243.rivalrebels.client.guihelper.GuiScroll;
import io.github.kadir1243.rivalrebels.client.renderhelper.RRTextures;
import io.github.kadir1243.rivalrebels.common.packet.JoinTeamPacket;
import io.github.kadir1243.rivalrebels.common.packet.ResetPacket;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsClass;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsPlayer;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsTeam;
import io.github.kadir1243.rivalrebels.common.util.Translations;
import io.github.kadir1243.rivalrebels.mixin.client.GuiGraphicsAccessor;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiSpawn
extends Screen {
    private final int xSizeOfTexture = 256;
    private final int ySizeOfTexture = 256;
    private int posX = (this.width - 256) / 2;
    private int posY = (this.height - 256) / 2;
    private GuiButton classButton;
    private GuiButton resetButton;
    private GuiButton omegaButton;
    private GuiButton sigmaButton;
    private GuiScroll omegaScroll;
    private GuiScroll sigmaScroll;
    private GuiScroll playerScroll;
    private GuiScroll gameScroll;
    private final RivalRebelsClass rrclass;

    public GuiSpawn(RivalRebelsClass rrc) {
        super((Component)Component.empty());
        this.rrclass = rrc;
    }

    public void init() {
        this.posX = (this.width - 256) / 2;
        this.posY = (this.height - 256) / 2;
        this.classButton = new GuiButton(this.posX + 188, this.posY + 102, 60, 11, (Component)Component.translatable((String)"RivalRebels.spawn.class"), button -> this.minecraft.setScreen((Screen)new GuiClass(this.rrclass)));
        this.resetButton = new GuiButton(this.posX + 188, this.posY + 119, 60, 11, (Component)Component.translatable((String)"RivalRebels.spawn.reset"), button -> {
            this.minecraft.setScreen((Screen)new GuiClass(this.rrclass));
            Minecraft.getInstance().getConnection().send((CustomPacketPayload)ResetPacket.INSTANCE);
        });
        this.omegaButton = new GuiButton(this.posX + 35, this.posY + 237, 60, 11, (Component)Component.translatable((String)"RivalRebels.spawn.joinomega"), button -> {
            Minecraft.getInstance().getConnection().send((CustomPacketPayload)new JoinTeamPacket(this.rrclass, RivalRebelsTeam.OMEGA));
            this.onClose();
        });
        this.sigmaButton = new GuiButton(this.posX + 160, this.posY + 237, 60, 11, (Component)Component.translatable((String)"RivalRebels.spawn.joinsigma"), button -> {
            Minecraft.getInstance().getConnection().send((CustomPacketPayload)new JoinTeamPacket(this.rrclass, RivalRebelsTeam.SIGMA));
            this.onClose();
        });
        this.omegaScroll = (GuiScroll)Button.builder((Component)Component.empty(), button -> {}).bounds(this.posX + 118, this.posY + 140, 5, 11).build(builder -> new GuiScroll((Button.Builder)builder, 80.0f));
        this.sigmaScroll = (GuiScroll)Button.builder((Component)Component.empty(), button -> {}).bounds(this.posX + 243, this.posY + 140, 5, 11).build(builder -> new GuiScroll((Button.Builder)builder, 80.0f));
        this.playerScroll = (GuiScroll)Button.builder((Component)Component.empty(), button -> {}).bounds(this.posX + 154, this.posY + 103, 5, 11).build(builder -> new GuiScroll((Button.Builder)builder, 16.0f));
        this.gameScroll = (GuiScroll)Button.builder((Component)Component.empty(), button -> {}).bounds(this.posX + 243, this.posY + 66, 5, 11).build(builder -> new GuiScroll((Button.Builder)builder, 16.0f));
        RivalRebelsPlayer nw = RivalRebels.round.rrplayerlist.getForGameProfile(this.minecraft.player.getGameProfile());
        this.resetButton.active = nw.resets > 0 && !nw.isreset;
        this.omegaButton.active = nw.rrteam == RivalRebelsTeam.NONE || nw.rrteam == RivalRebelsTeam.OMEGA;
        this.sigmaButton.active = nw.rrteam == RivalRebelsTeam.NONE || nw.rrteam == RivalRebelsTeam.SIGMA;
        this.classButton.active = nw.isreset;
        this.addRenderableWidget((GuiEventListener)this.classButton);
        this.addRenderableWidget((GuiEventListener)this.resetButton);
        this.addRenderableWidget((GuiEventListener)this.omegaButton);
        this.addRenderableWidget((GuiEventListener)this.sigmaButton);
        this.addRenderableWidget((GuiEventListener)this.omegaScroll);
        this.addRenderableWidget((GuiEventListener)this.sigmaScroll);
        this.addRenderableWidget((GuiEventListener)this.playerScroll);
        this.addRenderableWidget((GuiEventListener)this.gameScroll);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        RivalRebelsPlayer nw = RivalRebels.round.rrplayerlist.getForGameProfile(this.minecraft.player.getGameProfile());
        this.classButton.active = nw.isreset;
        this.omegaButton.active = nw.rrteam == RivalRebelsTeam.NONE || nw.rrteam == RivalRebelsTeam.OMEGA;
        this.sigmaButton.active = nw.rrteam == RivalRebelsTeam.NONE || nw.rrteam == RivalRebelsTeam.SIGMA;
        this.resetButton.active = nw.resets > 0 && !nw.isreset;
        float f = 0.00390625f;
        this.renderTransparentBackground(graphics);
        graphics.fillGradient(this.posX, this.posY, this.posX + 256, this.posY + 256, -16777216, -16777216);
        this.drawPanel(graphics, this.posX + 10, this.posY + 142, 80, this.omegaScroll.getScroll(), this.omegaScroll.limit, RivalRebelsTeam.OMEGA);
        this.drawPanel(graphics, this.posX + 135, this.posY + 142, 80, this.sigmaScroll.getScroll(), this.sigmaScroll.limit, RivalRebelsTeam.SIGMA);
        this.drawPanel(graphics, this.posX + 10, this.posY + 68, 228, 50, this.gameScroll.getScroll(), this.gameScroll.limit, RivalRebels.round.getMotD() + "\nMod by Rodolphito. \nVisit www.RivalRebels.com for official downloads.");
        graphics.fillGradient(this.posX + 6, this.posY + 99, this.posX + 161, this.posY + 131, -16777216, -16777216);
        this.drawPanel(graphics, this.posX + 10, this.posY + 105, 50, this.playerScroll.getScroll(), this.playerScroll.limit, new String[]{this.rrclass.name}, new int[]{this.rrclass.color});
        ((GuiGraphicsAccessor)graphics).blit(RenderPipelines.GUI_TEXTURED, RRTextures.guitspawn, this.posX, this.posX + 256, this.posY, this.posY + 256, 0.0f, 0.0f, 256.0f * f, 256.0f * f, 0);
        if (RRIdentifiers.banner != null) {
            ((GuiGraphicsAccessor)graphics).blit(RenderPipelines.GUI_TEXTURED, RRIdentifiers.banner, this.posX + 3, this.posX + 253, this.posY + 3, this.posY + 61, 0.0f, 0.0f, 1.0f, 1.0f, 0);
        }
        super.render(graphics, mouseX, mouseY, delta);
        graphics.drawString(this.font, String.valueOf(RivalRebels.round.getOmegaWins()), this.posX + 9, this.posY + 239, 0xFFFFFF, false);
        graphics.drawString(this.font, String.valueOf(RivalRebels.round.getSigmaWins()), this.posX + 134, this.posY + 239, 0xFFFFFF, false);
        if (this.resetButton.mouseClicked(mouseX, mouseY, 0) && this.resetButton.active) {
            graphics.fillGradient(mouseX, mouseY, mouseX + 120, mouseY + 20, -1441722095, -1441722095);
            float scalefactor = 0.666f;
            graphics.pose().pushMatrix();
            graphics.pose().scale(scalefactor, scalefactor);
            MultiLineLabel multiLineLabel = MultiLineLabel.create((Font)this.font, (Component)Translations.SPAWN_RESET_WARNING.translate(), (int)((int)(116.0f / scalefactor)));
            int n = (int)((float)(mouseX + 2) / scalefactor);
            int n2 = (int)((float)(mouseY + 2) / scalefactor);
            Objects.requireNonNull(this.font);
            multiLineLabel.renderLeftAlignedNoShadow(graphics, n, n2, 9, 0xFF0000);
            graphics.pose().popMatrix();
        }
    }

    protected void drawPanel(GuiGraphics graphics, int x, int y, int height, float scroll, float scrolllimit, RivalRebelsTeam team) {
        RivalRebelsPlayer player2;
        List newList = RivalRebels.round.rrplayerlist.players().stream().filter(player -> player.rrteam.equals((Object)team)).collect(Collectors.toList());
        if (newList.isEmpty()) {
            return;
        }
        newList.sort(Comparator.comparing(this::isOnline));
        int dist = (int)(-(scroll / scrolllimit) * (float)(newList.size() * 10 - height));
        boolean shouldScroll = newList.size() * 10 > height;
        for (int i = 0; i < newList.size() && (player2 = (RivalRebelsPlayer)newList.get(i)) != null; ++i) {
            int Y = dist + i * 10;
            if (!shouldScroll) {
                Y -= dist;
            }
            if (Y <= -9 || Y >= height + 9) continue;
            int color = player2.rrclass.color;
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            if (!this.isOnline(player2)) {
                r /= 2;
                g /= 2;
                b /= 2;
            }
            color = r << 16 | g << 8 | b;
            graphics.drawString(this.font, player2.getUsername(), x, y + Y, color, false);
        }
    }

    protected void drawPanel(GuiGraphics graphics, int x, int y, int height, float scroll, float scrolllimit, String[] display, int[] color) {
        int dist = (int)(-(scroll / scrolllimit) * (float)(display.length * 10 - height));
        boolean shouldScroll = display.length * 10 > height;
        for (int i = 0; i < display.length; ++i) {
            int Y = dist + i * 10;
            if (!shouldScroll) {
                Y -= dist;
            }
            if (Y <= -9 || Y >= height + 9) continue;
            graphics.drawString(this.font, (Component)Component.translatable((String)display[i]), x, y + Y, color[i], false);
        }
    }

    protected void drawPanel(GuiGraphics graphics, int x, int y, int width, int height, float scroll, float scrolllimit, String display) {
        int length = 10;
        int dist = (int)(-(scroll / scrolllimit) * (float)(length * 10 - height));
        float scalefactor = 0.6666f;
        graphics.pose().pushMatrix();
        graphics.pose().scale(scalefactor, scalefactor);
        MultiLineLabel multiLineLabel = MultiLineLabel.create((Font)this.font, (Component)Component.nullToEmpty((String)display), (int)((int)((double)width * 1.5)));
        int n = (int)((double)x * 1.5);
        int n2 = (int)((double)(y + dist) * 1.5);
        Objects.requireNonNull(this.font);
        multiLineLabel.renderLeftAlignedNoShadow(graphics, n, n2, 9, 0xFFFFFF);
        graphics.pose().popMatrix();
    }

    protected boolean isOnline(RivalRebelsPlayer user) {
        if (this.minecraft == null || this.minecraft.getConnection() == null || this.minecraft.getConnection().getOnlinePlayers().isEmpty()) {
            return false;
        }
        for (PlayerInfo guiPlayerInfo : this.minecraft.getConnection().getOnlinePlayers()) {
            if (!user.profile.equals((Object)guiPlayerInfo.getProfile())) continue;
            return true;
        }
        return false;
    }
}

