/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.guihelper;

import io.github.kadir1243.rivalrebels.client.guihelper.GuiButton;
import io.github.kadir1243.rivalrebels.client.renderhelper.RRTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiRotor
extends GuiButton {
    protected int degree;
    protected boolean pressed;

    public GuiRotor(int x, int y, int yawLimit, Component message) {
        super(x, y, 32, 32, message);
        this.degree = yawLimit / 2;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        graphics.pose().pushMatrix();
        int deg = this.degree % 180;
        if (this.degree >= 180) {
            deg = 180 - deg;
        }
        if (deg < 22) {
            deg = 22;
        }
        this.degree = deg;
        RRTextures.guitray.blit(graphics, this.getX(), this.getY(), 224.0f, 66.0f, this.width, this.height * deg / 180, -1);
        graphics.drawCenteredString(Minecraft.getInstance().font, deg * 2 + "\u00b0", this.getX() + this.width / 2, this.getY() + this.height / 2 - 4, 0xFFFFFF);
        graphics.pose().popMatrix();
    }

    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (Minecraft.getInstance().mouseHandler.isLeftPressed()) {
            if (this.mouseClicked(mouseX, mouseY, 0)) {
                this.pressed = true;
            }
            if (this.pressed) {
                this.degree = ((int)(Math.atan2((double)this.getY() - mouseY + (double)(this.height / 2), (double)this.getX() - mouseX + (double)(this.width / 2)) * 57.2957763671875) + 270) % 360;
            }
        } else {
            this.pressed = false;
        }
    }

    public void onRelease(double mouseX, double mouseY) {
        this.pressed = false;
    }

    public int getDegree() {
        return this.degree;
    }
}

