/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Transformation;
import io.github.kadir1243.rivalrebels.client.renderhelper.QuadHelper;
import io.github.kadir1243.rivalrebels.common.entity.EntityRocket;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextMap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.ExtendedUnbakedGeometry;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ModelRocket
implements ExtendedUnbakedGeometry {
    public static final ModelRocket INSTANCE = new ModelRocket();
    private static final Vector3f vy1 = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f vy2 = new Vector3f(0.0f, 2.5f, 0.0f);
    private static final Vector3f vpx1 = new Vector3f(0.5f, 0.0f, 0.0f);
    private static final Vector3f vnx1 = new Vector3f(-0.5f, 0.0f, 0.0f);
    private static final Vector3f vpz1 = new Vector3f(0.0f, 0.0f, 0.5f);
    private static final Vector3f vnz1 = new Vector3f(0.0f, 0.0f, -0.5f);
    private static final Vector3f vpxpz1 = new Vector3f(0.3535533f, 0.0f, 0.3535533f);
    private static final Vector3f vpxnz1 = new Vector3f(0.3535533f, 0.0f, -0.3535533f);
    private static final Vector3f vnxpz1 = new Vector3f(-0.3535533f, 0.0f, 0.3535533f);
    private static final Vector3f vnxnz1 = new Vector3f(-0.3535533f, 0.0f, -0.3535533f);
    private static final Vector3f vpx2 = new Vector3f(0.5f, 2.0f, 0.0f);
    private static final Vector3f vnx2 = new Vector3f(-0.5f, 2.0f, 0.0f);
    private static final Vector3f vpz2 = new Vector3f(0.0f, 2.0f, 0.5f);
    private static final Vector3f vnz2 = new Vector3f(0.0f, 2.0f, -0.5f);
    private static final Vector3f vpxpz2 = new Vector3f(0.3535533f, 2.0f, 0.3535533f);
    private static final Vector3f vpxnz2 = new Vector3f(0.3535533f, 2.0f, -0.3535533f);
    private static final Vector3f vnxpz2 = new Vector3f(-0.3535533f, 2.0f, 0.3535533f);
    private static final Vector3f vnxnz2 = new Vector3f(-0.3535533f, 2.0f, -0.3535533f);
    private static final Vector3f vpx3 = new Vector3f(1.0f, -0.2f, 0.0f);
    private static final Vector3f vnx3 = new Vector3f(-1.0f, -0.2f, 0.0f);
    private static final Vector3f vpz3 = new Vector3f(0.0f, -0.2f, 1.0f);
    private static final Vector3f vnz3 = new Vector3f(0.0f, -0.2f, -1.0f);
    private static final Vector3f vpx4 = new Vector3f(1.0f, 1.0f, 0.0f);
    private static final Vector3f vnx4 = new Vector3f(-1.0f, 1.0f, 0.0f);
    private static final Vector3f vpz4 = new Vector3f(0.0f, 1.0f, 1.0f);
    private static final Vector3f vnz4 = new Vector3f(0.0f, 1.0f, -1.0f);
    private static final float tx1 = 0.0f;
    private static final float tx2 = 0.28125f;
    private static final float tx3 = 0.375f;
    private static final float tx4 = 0.5625f;
    private static final float tx5 = 0.65625f;
    private static final float ty1 = 0.0f;
    private static final float ty2 = 0.09375f;
    private static final float ty3 = 0.1875f;
    private static final Supplier<QuadHelper.BakedData> BAKED_MODEL_WITHOUT_FINS = QuadHelper.createBakedModel(buffer -> {
        QuadHelper.addFace(buffer, vpx1, vpx2, vpxpz2, vpxpz1, 0.0f, 0.28125f, 0.0f, 0.09375f);
        QuadHelper.addFace(buffer, vpxpz1, vpxpz2, vpz2, vpz1, 0.0f, 0.28125f, 0.0f, 0.09375f);
        QuadHelper.addFace(buffer, vpz1, vpz2, vnxpz2, vnxpz1, 0.0f, 0.28125f, 0.0f, 0.09375f);
        QuadHelper.addFace(buffer, vnxpz1, vnxpz2, vnx2, vnx1, 0.0f, 0.28125f, 0.0f, 0.09375f);
        QuadHelper.addFace(buffer, vnx1, vnx2, vnxnz2, vnxnz1, 0.0f, 0.28125f, 0.0f, 0.09375f);
        QuadHelper.addFace(buffer, vnxnz1, vnxnz2, vnz2, vnz1, 0.0f, 0.28125f, 0.0f, 0.09375f);
        QuadHelper.addFace(buffer, vnz1, vnz2, vpxnz2, vpxnz1, 0.0f, 0.28125f, 0.0f, 0.09375f);
        QuadHelper.addFace(buffer, vpxnz1, vpxnz2, vpx2, vpx1, 0.0f, 0.28125f, 0.0f, 0.09375f);
        QuadHelper.addFace(buffer, vpxpz2, vpx2, vy2, vpz2, 0.28125f, 0.375f, 0.0f, 0.09375f);
        QuadHelper.addFace(buffer, vnxpz2, vpz2, vy2, vnx2, 0.28125f, 0.375f, 0.0f, 0.09375f);
        QuadHelper.addFace(buffer, vnxnz2, vnx2, vy2, vnz2, 0.28125f, 0.375f, 0.0f, 0.09375f);
        QuadHelper.addFace(buffer, vpxnz2, vnz2, vy2, vpx2, 0.28125f, 0.375f, 0.0f, 0.09375f);
        QuadHelper.addFace(buffer, vpx1, vpxpz1, vpz1, vy1, 0.5625f, 0.65625f, 0.0f, 0.09375f);
        QuadHelper.addFace(buffer, vpz1, vnxpz1, vnx1, vy1, 0.5625f, 0.65625f, 0.0f, 0.09375f);
        QuadHelper.addFace(buffer, vnx1, vnxnz1, vnz1, vy1, 0.5625f, 0.65625f, 0.0f, 0.09375f);
        QuadHelper.addFace(buffer, vnz1, vpxnz1, vpx1, vy1, 0.5625f, 0.65625f, 0.0f, 0.09375f);
    });
    private static final Supplier<QuadHelper.BakedData> BAKED_MODEL_FINS = QuadHelper.createBakedModel(buffer -> {
        QuadHelper.addFace(buffer, vnx3, vpx3, vpx4, vnx4, 0.375f, 0.5625f, 0.0f, 0.1875f);
        QuadHelper.addFace(buffer, vpx3, vnx3, vnx4, vpx4, 0.375f, 0.5625f, 0.0f, 0.1875f);
        QuadHelper.addFace(buffer, vnz3, vpz3, vpz4, vnz4, 0.375f, 0.5625f, 0.0f, 0.1875f);
        QuadHelper.addFace(buffer, vpz3, vnz3, vnz4, vpz4, 0.375f, 0.5625f, 0.0f, 0.1875f);
    });

    public static void render(PoseStack pose, MultiBufferSource vertexConsumers, ResourceLocation texture, boolean fins, int light, int overlay) {
        VertexConsumer buffer = vertexConsumers.getBuffer(RenderType.entitySolid((ResourceLocation)texture));
        pose.pushPose();
        pose.scale(0.125f, 0.25f, 0.125f);
        ModelBlockRenderer.renderModel((PoseStack.Pose)pose.last(), (VertexConsumer)buffer, (BlockStateModel)BAKED_MODEL_WITHOUT_FINS.get().blockStateModel(), (float)1.0f, (float)1.0f, (float)1.0f, (int)light, (int)overlay);
        if (fins) {
            ModelBlockRenderer.renderModel((PoseStack.Pose)pose.last(), (VertexConsumer)buffer, (BlockStateModel)BAKED_MODEL_FINS.get().blockStateModel(), (float)1.0f, (float)1.0f, (float)1.0f, (int)light, (int)overlay);
        }
        pose.popPose();
    }

    public QuadCollection bake(TextureSlots textureSlots, ModelBaker baker, ModelState state, ModelDebugName debugName, ContextMap additionalProperties) {
        Boolean has_fins = (Boolean)additionalProperties.getOrDefault(EntityRocket.HAS_FINS, (Object)false);
        return QuadHelper.createBakedModel(buffer -> {
            QuadHelper.addFace(buffer, vpx1, vpx2, vpxpz2, vpxpz1, 0.0f, 0.28125f, 0.0f, 0.09375f);
            QuadHelper.addFace(buffer, vpxpz1, vpxpz2, vpz2, vpz1, 0.0f, 0.28125f, 0.0f, 0.09375f);
            QuadHelper.addFace(buffer, vpz1, vpz2, vnxpz2, vnxpz1, 0.0f, 0.28125f, 0.0f, 0.09375f);
            QuadHelper.addFace(buffer, vnxpz1, vnxpz2, vnx2, vnx1, 0.0f, 0.28125f, 0.0f, 0.09375f);
            QuadHelper.addFace(buffer, vnx1, vnx2, vnxnz2, vnxnz1, 0.0f, 0.28125f, 0.0f, 0.09375f);
            QuadHelper.addFace(buffer, vnxnz1, vnxnz2, vnz2, vnz1, 0.0f, 0.28125f, 0.0f, 0.09375f);
            QuadHelper.addFace(buffer, vnz1, vnz2, vpxnz2, vpxnz1, 0.0f, 0.28125f, 0.0f, 0.09375f);
            QuadHelper.addFace(buffer, vpxnz1, vpxnz2, vpx2, vpx1, 0.0f, 0.28125f, 0.0f, 0.09375f);
            QuadHelper.addFace(buffer, vpxpz2, vpx2, vy2, vpz2, 0.28125f, 0.375f, 0.0f, 0.09375f);
            QuadHelper.addFace(buffer, vnxpz2, vpz2, vy2, vnx2, 0.28125f, 0.375f, 0.0f, 0.09375f);
            QuadHelper.addFace(buffer, vnxnz2, vnx2, vy2, vnz2, 0.28125f, 0.375f, 0.0f, 0.09375f);
            QuadHelper.addFace(buffer, vpxnz2, vnz2, vy2, vpx2, 0.28125f, 0.375f, 0.0f, 0.09375f);
            QuadHelper.addFace(buffer, vpx1, vpxpz1, vpz1, vy1, 0.5625f, 0.65625f, 0.0f, 0.09375f);
            QuadHelper.addFace(buffer, vpz1, vnxpz1, vnx1, vy1, 0.5625f, 0.65625f, 0.0f, 0.09375f);
            QuadHelper.addFace(buffer, vnx1, vnxnz1, vnz1, vy1, 0.5625f, 0.65625f, 0.0f, 0.09375f);
            QuadHelper.addFace(buffer, vnz1, vpxnz1, vpx1, vy1, 0.5625f, 0.65625f, 0.0f, 0.09375f);
            if (has_fins.booleanValue()) {
                QuadHelper.addFace(buffer, vnx3, vpx3, vpx4, vnx4, 0.375f, 0.5625f, 0.0f, 0.1875f);
                QuadHelper.addFace(buffer, vpx3, vnx3, vnx4, vpx4, 0.375f, 0.5625f, 0.0f, 0.1875f);
                QuadHelper.addFace(buffer, vnz3, vpz3, vpz4, vnz4, 0.375f, 0.5625f, 0.0f, 0.1875f);
                QuadHelper.addFace(buffer, vpz3, vnz3, vnz4, vpz4, 0.375f, 0.5625f, 0.0f, 0.1875f);
            }
        }, Transformation.identity());
    }
}

