/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class RenderLibrary {
    public static void renderModel(PoseStack poseStack, MultiBufferSource bufferSource, float x1, float y1, float z1, float x, float y, float z, float segDist, float radius, int steps, float arcRatio, float rvar, float r, float g, float b, float a) {
        RandomSource random = Minecraft.getInstance().level.random;
        poseStack.pushPose();
        poseStack.translate(x1, y1, z1);
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.lightning());
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)(Math.atan2(x, z) * 57.295779513 - 90.0)));
        float dist = Mth.sqrt((float)(x * x + z * z));
        float hdist = dist / 2.0f;
        float hdists = hdist * hdist;
        float rs = radius / (float)steps;
        int segNum = Mth.ceil((float)(dist / segDist)) + 1;
        float[] xv = new float[segNum];
        float[] yv = new float[segNum];
        float[] zv = new float[segNum];
        int color = ARGB.colorFromFloat((float)a, (float)r, (float)g, (float)b);
        for (int i = 1; i < segNum; ++i) {
            float interp = (float)i / (float)segNum;
            float X = dist * interp;
            float Y = y * interp;
            float ihdist = dist * interp - hdist;
            xv[i] = X;
            yv[i] = (float)((double)(Y += (hdists - ihdist * ihdist) / hdists * arcRatio) + random.nextGaussian() * (double)rvar);
            zv[i] = (float)(random.nextGaussian() * (double)rvar);
        }
        xv[0] = 0.0f;
        yv[0] = 0.0f;
        zv[0] = 0.0f;
        for (int o = 0; o < steps; ++o) {
            for (int i = 1; i < segNum; ++i) {
                float s = rs * (float)o;
                buffer.addVertex(poseStack.last(), xv[i - 1], yv[i - 1] + s, zv[i - 1] - s).setColor(color);
                buffer.addVertex(poseStack.last(), xv[i - 1], yv[i - 1] + s, zv[i - 1] + s).setColor(color);
                buffer.addVertex(poseStack.last(), xv[i], yv[i] + s, zv[i] + s).setColor(color);
                buffer.addVertex(poseStack.last(), xv[i], yv[i] + s, zv[i] - s).setColor(color);
                buffer.addVertex(poseStack.last(), xv[i - 1], yv[i - 1] + s, zv[i - 1] + s).setColor(color);
                buffer.addVertex(poseStack.last(), xv[i - 1], yv[i - 1] - s, zv[i - 1] + s).setColor(color);
                buffer.addVertex(poseStack.last(), xv[i], yv[i] - s, zv[i] + s).setColor(color);
                buffer.addVertex(poseStack.last(), xv[i], yv[i] + s, zv[i] + s).setColor(color);
                buffer.addVertex(poseStack.last(), xv[i - 1], yv[i - 1] - s, zv[i - 1] - s).setColor(color);
                buffer.addVertex(poseStack.last(), xv[i - 1], yv[i - 1] + s, zv[i - 1] - s).setColor(color);
                buffer.addVertex(poseStack.last(), xv[i], yv[i] + s, zv[i] - s).setColor(color);
                buffer.addVertex(poseStack.last(), xv[i], yv[i] - s, zv[i] - s).setColor(color);
                buffer.addVertex(poseStack.last(), xv[i - 1], yv[i - 1] - s, zv[i - 1] + s).setColor(color);
                buffer.addVertex(poseStack.last(), xv[i - 1], yv[i - 1] - s, zv[i - 1] - s).setColor(color);
                buffer.addVertex(poseStack.last(), xv[i], yv[i] - s, zv[i] - s).setColor(color);
                buffer.addVertex(poseStack.last(), xv[i], yv[i] - s, zv[i] + s).setColor(color);
            }
        }
        poseStack.popPose();
    }
}

