/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.client.model.ModelAntimatterBombBlast;
import io.github.kadir1243.rivalrebels.client.model.ModelBlastRing;
import io.github.kadir1243.rivalrebels.client.model.ModelBlastSphere;
import io.github.kadir1243.rivalrebels.client.renderhelper.RenderTypes;
import io.github.kadir1243.rivalrebels.common.entity.EntityAntimatterBombBlast;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class RenderAntimatterBombBlast
extends EntityRenderer<EntityAntimatterBombBlast, State> {
    private final ModelAntimatterBombBlast modelabomb = new ModelAntimatterBombBlast();

    public RenderAntimatterBombBlast(EntityRendererProvider.Context manager) {
        super(manager);
    }

    public void render(State renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        RandomSource random = renderState.random;
        double radius = (renderState.deltaMovement.x() * 10.0 - 1.0) * (renderState.deltaMovement.x() * 10.0 - 1.0) * 2.0 + (double)RRConfig.SERVER.getTsarBombaStrength();
        poseStack.pushPose();
        poseStack.pushPose();
        poseStack.scale(RRConfig.CLIENT.getShroomScale(), RRConfig.CLIENT.getShroomScale(), RRConfig.CLIENT.getShroomScale());
        float size = renderState.ageInTicks % 100.0f * 2.0f;
        ModelBlastRing.renderModel(poseStack, bufferSource.getBuffer(RenderType.solid()), size, 64, 6.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, ARGB.colorFromFloat((float)1.0f, (float)0.0f, (float)0.0f, (float)0.2f), packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        if (renderState.ageInTicks < 60.0f) {
            double elev = renderState.ageInTicks / 5.0f;
            poseStack.translate(0.0, elev, 0.0);
            ModelBlastSphere.renderModel(poseStack, bufferSource, renderState.ageInTicks, -1);
        } else {
            poseStack.scale((float)(radius * (double)0.06f), (float)(radius * (double)0.06f), (float)(radius * (double)0.06f));
            this.modelabomb.render(poseStack, bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.etantimatterblast)), packedLight);
        }
        poseStack.popPose();
        if (RRConfig.CLIENT.isAntimatterFlash()) {
            int i;
            int ran = (int)(random.nextDouble() * 10.0 - 5.0);
            for (i = 0; i < ran; ++i) {
                poseStack.popPose();
            }
            for (i = -5; i < 0; ++i) {
                poseStack.pushPose();
            }
            poseStack.scale(random.nextFloat(), random.nextFloat(), random.nextFloat());
            poseStack.mulPose((Quaternionfc)Axis.of((Vector3f)new Vector3f(random.nextFloat(), random.nextFloat(), random.nextFloat())).rotationDegrees(random.nextFloat() * 360.0f));
            poseStack.translate(random.nextDouble() * 10.0 - 5.0, random.nextDouble() * 10.0 - 5.0, random.nextDouble() * 10.0 - 5.0);
            ModelBlastSphere.renderModel(poseStack, bufferSource.getBuffer(RenderTypes.ANTIMATTER_BOMB_BLAST_ENTITY), renderState.ageInTicks, ARGB.colorFromFloat((float)1.0f, (float)((float)random.nextDouble()), (float)((float)random.nextDouble()), (float)((float)random.nextDouble())));
        }
    }

    public boolean shouldRender(EntityAntimatterBombBlast livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    protected boolean affectedByCulling(EntityAntimatterBombBlast p_365169_) {
        return false;
    }

    protected int getBlockLightLevel(EntityAntimatterBombBlast entity, BlockPos pos) {
        return 15;
    }

    public State createRenderState() {
        return new State();
    }

    public void extractRenderState(EntityAntimatterBombBlast p_entity, State reusedState, float partialTick) {
        super.extractRenderState((Entity)p_entity, (EntityRenderState)reusedState, partialTick);
        reusedState.random = p_entity.getRandom();
        reusedState.deltaMovement = p_entity.getDeltaMovement();
    }

    public static class State
    extends EntityRenderState {
        public RandomSource random;
        public Vec3 deltaMovement;
    }
}

