/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.client.model.ObjModels;
import io.github.kadir1243.rivalrebels.common.entity.EntityB2Spirit;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class RenderB2Spirit
extends EntityRenderer<EntityB2Spirit, State> {
    private final QuadCollection b2ForSpiritModel;
    private final QuadCollection shuttleModel;
    private final QuadCollection tupolevModel;

    public RenderB2Spirit(EntityRendererProvider.Context context) {
        super(context);
        ModelManager modelManager = context.getModelManager();
        this.b2ForSpiritModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.B2_FOR_SPIRIT_MODEL);
        this.shuttleModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.SHUTTLE_MODEL);
        this.tupolevModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.TUPOLEV_MODEL);
    }

    public void render(State renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.yRot));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.xRot));
        if (RRConfig.CLIENT.getBomberType().equals("sh")) {
            poseStack.scale(3.0f, 3.0f, 3.0f);
            ObjModels.render(this.shuttleModel, bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.etb2spirit)), poseStack, -1, packedLight, OverlayTexture.NO_OVERLAY);
        } else if (RRConfig.CLIENT.getBomberType().equals("tu")) {
            ObjModels.render(this.tupolevModel, bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.ettupolev)), poseStack, -1, packedLight, OverlayTexture.NO_OVERLAY);
        } else {
            poseStack.scale(3.0f, 3.0f, 3.0f);
            ObjModels.render(this.b2ForSpiritModel, bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.etb2spirit)), poseStack, -1, packedLight, OverlayTexture.NO_OVERLAY);
        }
        poseStack.popPose();
    }

    protected boolean affectedByCulling(EntityB2Spirit p_365169_) {
        return false;
    }

    public boolean shouldRender(EntityB2Spirit livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public State createRenderState() {
        return new State();
    }

    public void extractRenderState(EntityB2Spirit p_entity, State reusedState, float partialTick) {
        super.extractRenderState((Entity)p_entity, (EntityRenderState)reusedState, partialTick);
        reusedState.xRot = p_entity.getXRot(partialTick);
        reusedState.yRot = p_entity.getYRot(partialTick);
    }

    public static class State
    extends EntityRenderState {
        public float xRot;
        public float yRot;
    }
}

