/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.client.model.ModelBlastSphere;
import io.github.kadir1243.rivalrebels.client.model.ModelNuclearBomb;
import io.github.kadir1243.rivalrebels.common.entity.EntityBomb;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class RenderBomb
extends EntityRenderer<EntityBomb, State> {
    public RenderBomb(EntityRendererProvider.Context manager) {
        super(manager);
    }

    public void render(State renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.yRot - 90.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(renderState.xRot - 90.0f));
        if (renderState.deltaMovement.x() == 0.0 && renderState.deltaMovement.z() == 0.0) {
            if (renderState.deltaMovement.y() == 1.0) {
                ModelBlastSphere.renderModel(poseStack, bufferSource, renderState.ageInTicks * 0.2f, 0.25f, 0.25f, 1.0f, 0.75f);
            } else if (renderState.deltaMovement.y() == 0.0) {
                ModelBlastSphere.renderModel(poseStack, bufferSource, renderState.ageInTicks * 0.2f, 0.8f, 0.8f, 1.0f, 0.75f);
            }
        } else {
            poseStack.scale(0.25f, 0.5f, 0.25f);
            ModelNuclearBomb.renderModel(poseStack, bufferSource, RRIdentifiers.etnuke, packedLight, true);
        }
        poseStack.popPose();
    }

    public boolean shouldRender(EntityBomb livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public State createRenderState() {
        return new State();
    }

    public void extractRenderState(EntityBomb p_entity, State reusedState, float partialTick) {
        super.extractRenderState((Entity)p_entity, (EntityRenderState)reusedState, partialTick);
        reusedState.xRot = p_entity.getXRot(partialTick);
        reusedState.yRot = p_entity.getYRot(partialTick);
        reusedState.deltaMovement = p_entity.getDeltaMovement();
    }

    public static class State
    extends EntityRenderState {
        public float xRot;
        public float yRot;
        public Vec3 deltaMovement;
    }
}

