/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class RenderBullet
extends EntityRenderer<Entity, EntityRenderState> {
    private final String path;

    public RenderBullet(EntityRendererProvider.Context manager, String path) {
        super(manager);
        this.path = path;
    }

    public EntityRenderState createRenderState() {
        return new EntityRenderState();
    }

    public void render(EntityRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (renderState.ageInTicks > 1.0f) {
            poseStack.pushPose();
            poseStack.scale(0.5f, 0.5f, 0.5f);
            float var7 = 1.0f;
            float var8 = 0.5f;
            float var9 = 0.25f;
            poseStack.mulPose((Quaternionfc)this.entityRenderDispatcher.cameraOrientation());
            VertexConsumer buffer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)this.getTextureLocation()));
            buffer.addVertex(poseStack.last(), 0.0f - var8, 0.0f - var9, 0.0f).setColor(-1).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
            buffer.addVertex(poseStack.last(), var7 - var8, 0.0f - var9, 0.0f).setColor(-1).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
            buffer.addVertex(poseStack.last(), var7 - var8, var7 - var9, 0.0f).setColor(-1).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
            buffer.addVertex(poseStack.last(), 0.0f - var8, var7 - var9, 0.0f).setColor(-1).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
            poseStack.popPose();
        }
    }

    public ResourceLocation getTextureLocation() {
        if (this.path.equals("flame")) {
            return RRIdentifiers.etflame;
        }
        if (this.path.equals("fire")) {
            return RRIdentifiers.etfire;
        }
        return null;
    }

    public boolean shouldRender(Entity entity, Frustum camera, double camX, double camY, double camZ) {
        return entity.shouldRender(camX, camY, camZ);
    }

    protected int getBlockLightLevel(Entity entity, BlockPos pos) {
        return 15;
    }
}

