/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.common.entity.EntityLaserBurst;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class RenderLaserBurst
extends EntityRenderer<EntityLaserBurst, State> {
    private static final float red = 1.0f;

    public RenderLaserBurst(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(State renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float radius = 0.12f;
        int distance = 4;
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.lightning());
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.yRot));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-renderState.xRot));
        for (float o = 0.0f; o <= radius; o += radius / 8.0f) {
            float color = 1.0f - o * 8.333f;
            if (color < 0.0f) {
                color = 0.0f;
            }
            buffer.addVertex(poseStack.last(), 0.0f + o, 0.0f - o, 0.0f).setColor(1.0f, color, color, 1.0f);
            buffer.addVertex(poseStack.last(), 0.0f + o, 0.0f + o, 0.0f).setColor(1.0f, color, color, 1.0f);
            buffer.addVertex(poseStack.last(), 0.0f + o, 0.0f + o, (float)distance).setColor(1.0f, color, color, 1.0f);
            buffer.addVertex(poseStack.last(), 0.0f + o, 0.0f - o, (float)distance).setColor(1.0f, color, color, 1.0f);
            buffer.addVertex(poseStack.last(), 0.0f - o, 0.0f - o, 0.0f).setColor(1.0f, color, color, 1.0f);
            buffer.addVertex(poseStack.last(), 0.0f - o, 0.0f - o, (float)distance).setColor(1.0f, color, color, 1.0f);
            buffer.addVertex(poseStack.last(), 0.0f - o, 0.0f + o, 0.0f).setColor(1.0f, color, color, 1.0f);
            buffer.addVertex(poseStack.last(), 0.0f - o, 0.0f + o, (float)distance).setColor(1.0f, color, color, 1.0f);
        }
        poseStack.popPose();
    }

    public boolean shouldRender(EntityLaserBurst livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    protected int getBlockLightLevel(EntityLaserBurst entity, BlockPos pos) {
        return 15;
    }

    public State createRenderState() {
        return new State();
    }

    public void extractRenderState(EntityLaserBurst p_entity, State reusedState, float partialTick) {
        super.extractRenderState((Entity)p_entity, (EntityRenderState)reusedState, partialTick);
        reusedState.xRot = p_entity.getXRot(partialTick);
        reusedState.yRot = p_entity.getYRot(partialTick);
    }

    public static class State
    extends EntityRenderState {
        public float xRot;
        public float yRot;
    }
}

