/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.client.renderhelper.RenderTypes;
import io.github.kadir1243.rivalrebels.common.entity.EntityLaserLink;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class RenderLaserLink
extends EntityRenderer<EntityLaserLink, State> {
    private static final int COLOR = ARGB.colorFromFloat((float)1.0f, (float)0.5f, (float)0.1f, (float)0.1f);

    public RenderLaserLink(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(State renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float distance = (float)(renderState.deltaMovement.x() * 100.0);
        if (distance > 0.0f) {
            float radius = 0.7f;
            VertexConsumer buffer = bufferSource.getBuffer(RenderTypes.LASER_LINK_ENTITY);
            poseStack.pushPose();
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-renderState.yRot));
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.xRot));
            for (float o = 0.0f; o <= radius; o += radius / 16.0f) {
                buffer.addVertex(poseStack.last(), 0.0f + o, 0.0f - o, 0.0f).setColor(COLOR);
                buffer.addVertex(poseStack.last(), 0.0f + o, 0.0f + o, 0.0f).setColor(COLOR);
                buffer.addVertex(poseStack.last(), 0.0f + o, 0.0f + o, 0.0f + distance).setColor(COLOR);
                buffer.addVertex(poseStack.last(), 0.0f + o, 0.0f - o, 0.0f + distance).setColor(COLOR);
                buffer.addVertex(poseStack.last(), 0.0f - o, 0.0f - o, 0.0f).setColor(COLOR);
                buffer.addVertex(poseStack.last(), 0.0f - o, 0.0f - o, 0.0f + distance).setColor(COLOR);
                buffer.addVertex(poseStack.last(), 0.0f - o, 0.0f + o, 0.0f).setColor(COLOR);
                buffer.addVertex(poseStack.last(), 0.0f - o, 0.0f + o, 0.0f + distance).setColor(COLOR);
            }
            poseStack.popPose();
        }
    }

    public boolean shouldRender(EntityLaserLink livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    protected int getBlockLightLevel(EntityLaserLink entity, BlockPos pos) {
        return 15;
    }

    public State createRenderState() {
        return new State();
    }

    public void extractRenderState(EntityLaserLink p_entity, State reusedState, float partialTick) {
        super.extractRenderState((Entity)p_entity, (EntityRenderState)reusedState, partialTick);
        reusedState.xRot = p_entity.getXRot(partialTick);
        reusedState.yRot = p_entity.getYRot(partialTick);
        reusedState.deltaMovement = p_entity.getDeltaMovement();
    }

    public static class State
    extends EntityRenderState {
        public float xRot;
        public float yRot;
        public Vec3 deltaMovement;
    }
}

