/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.client.model.ModelBlastRing;
import io.github.kadir1243.rivalrebels.client.renderhelper.RenderHelper;
import io.github.kadir1243.rivalrebels.client.renderhelper.RenderTypes;
import io.github.kadir1243.rivalrebels.client.renderhelper.TextureVertice;
import io.github.kadir1243.rivalrebels.common.entity.EntityNuclearBlast;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class RenderNuclearBlast
extends EntityRenderer<EntityNuclearBlast, State> {
    private float ring1 = 0.0f;
    private float ring2 = 0.0f;
    private float ring3 = 0.0f;
    private float height = 0.0f;
    private int textureCoordx = 0;
    private int textureCoordy = 0;

    public RenderNuclearBlast(EntityRendererProvider.Context manager) {
        super(manager);
    }

    public void render(State renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        if (renderState.ageInTicks < 600.0f) {
            VertexConsumer buffer = bufferSource.getBuffer(RenderType.solid());
            ModelBlastRing.renderModel(poseStack, buffer, RRConfig.CLIENT.getShroomScale() * this.ring1 * 15.0f, 64, 4.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, -3.0f, 0.0f, packedLight);
            ModelBlastRing.renderModel(poseStack, buffer, RRConfig.CLIENT.getShroomScale() * this.ring2, 32, 1.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, this.height + this.ring3, 0.0f, packedLight);
            ModelBlastRing.renderModel(poseStack, buffer, RRConfig.CLIENT.getShroomScale() * this.ring3, 32, 2.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, this.height + 7.0f + this.ring2, 0.0f, packedLight);
            if (renderState.ageInTicks > 550.0f) {
                this.ring2 += 0.1f;
                this.ring3 += 0.1f;
            }
        } else {
            this.ring1 = 0.0f;
            this.ring2 = 0.0f;
            this.ring3 = 0.0f;
            this.height = 0.0f;
        }
        --this.textureCoordy;
        if (this.textureCoordy <= 0) {
            this.textureCoordy = 128;
        }
        float par5 = (float)(this.textureCoordx + 128) / 128.0f;
        float par6 = (float)this.textureCoordx / 128.0f;
        float par7 = (float)(this.textureCoordy + 128) / 128.0f;
        float par8 = (float)this.textureCoordy / 128.0f;
        poseStack.pushPose();
        poseStack.translate(0.0f, -10.0f, 0.0f);
        poseStack.scale(RRConfig.CLIENT.getShroomScale(), RRConfig.CLIENT.getShroomScale(), RRConfig.CLIENT.getShroomScale());
        poseStack.scale(0.5f + (float)renderState.deltaMovement.y() * 0.3f, 2.6f + (float)renderState.deltaMovement.y() * 0.3f, 0.5f + (float)renderState.deltaMovement.y() * 0.3f);
        ResourceLocation identifier = renderState.deltaMovement.x() == 1.0 ? RRIdentifiers.ettroll : RRIdentifiers.etradiation;
        VertexConsumer quadSolid = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)identifier));
        int size = (int)renderState.deltaMovement.y();
        Vector3f pxv1 = new Vector3f(4.0f, 0.0f - (float)size * 2.5f, 0.0f);
        Vector3f nxv1 = new Vector3f(-4.0f, 0.0f - (float)size * 2.5f, 0.0f);
        Vector3f pzv1 = new Vector3f(0.0f, 0.0f - (float)size * 2.5f, 4.0f);
        Vector3f nzv1 = new Vector3f(0.0f, 0.0f - (float)size * 2.5f, -4.0f);
        Vector3f pxv2 = new Vector3f(2.0f, 1.5f - (float)size * 2.0f, 0.0f);
        Vector3f nxv2 = new Vector3f(-2.0f, 1.5f - (float)size * 2.0f, 0.0f);
        Vector3f pzv2 = new Vector3f(0.0f, 1.5f - (float)size * 2.0f, 2.0f);
        Vector3f nzv2 = new Vector3f(0.0f, 1.5f - (float)size * 2.0f, -2.0f);
        Vector3f pxv3 = new Vector3f(1.5f, 3.5f - (float)size * 1.5f, 0.0f);
        Vector3f nxv3 = new Vector3f(-1.5f, 3.5f - (float)size * 1.5f, 0.0f);
        Vector3f pzv3 = new Vector3f(0.0f, 3.5f - (float)size * 1.5f, 1.5f);
        Vector3f nzv3 = new Vector3f(0.0f, 3.5f - (float)size * 1.5f, -1.5f);
        Vector3f pxv4 = new Vector3f(1.5f, 6.5f - (float)size * 1.0f, 0.0f);
        Vector3f nxv4 = new Vector3f(-1.5f, 6.5f - (float)size * 1.0f, 0.0f);
        Vector3f pzv4 = new Vector3f(0.0f, 6.5f - (float)size * 1.0f, 1.5f);
        Vector3f nzv4 = new Vector3f(0.0f, 6.5f - (float)size * 1.0f, -1.5f);
        Vector3f pxv5 = new Vector3f(2.0f, 9.5f - (float)size * 0.5f, 0.0f);
        Vector3f nxv5 = new Vector3f(-2.0f, 9.5f - (float)size * 0.5f, 0.0f);
        Vector3f pzv5 = new Vector3f(0.0f, 9.5f - (float)size * 0.5f, 2.0f);
        Vector3f nzv5 = new Vector3f(0.0f, 9.5f - (float)size * 0.5f, -2.0f);
        Vector3f pxv6 = new Vector3f(3.0f, 11.0f, 0.0f);
        Vector3f nxv6 = new Vector3f(-3.0f, 11.0f, 0.0f);
        Vector3f pzv6 = new Vector3f(0.0f, 11.0f, 3.0f);
        Vector3f nzv6 = new Vector3f(0.0f, 11.0f, -3.0f);
        Vector3f pxv7 = new Vector3f(16.0f, 10.0f, 0.0f);
        Vector3f nxv7 = new Vector3f(-16.0f, 10.0f, 0.0f);
        Vector3f pzv7 = new Vector3f(0.0f, 10.0f, 16.0f);
        Vector3f nzv7 = new Vector3f(0.0f, 10.0f, -16.0f);
        Vector3f ppv7 = new Vector3f(8.0f, 10.0f, 8.0f);
        Vector3f npv7 = new Vector3f(-8.0f, 10.0f, 8.0f);
        Vector3f pnv7 = new Vector3f(8.0f, 10.0f, -8.0f);
        Vector3f nnv7 = new Vector3f(-8.0f, 10.0f, -8.0f);
        Vector3f pxv8 = new Vector3f(32.0f, 12.0f, 0.0f);
        Vector3f nxv8 = new Vector3f(-32.0f, 12.0f, 0.0f);
        Vector3f pzv8 = new Vector3f(0.0f, 12.0f, 32.0f);
        Vector3f nzv8 = new Vector3f(0.0f, 12.0f, -32.0f);
        Vector3f ppv8 = new Vector3f(22.5f, 12.0f, 22.5f);
        Vector3f npv8 = new Vector3f(-22.5f, 12.0f, 22.5f);
        Vector3f pnv8 = new Vector3f(22.5f, 12.0f, -22.5f);
        Vector3f nnv8 = new Vector3f(-22.5f, 12.0f, -22.5f);
        Vector3f pxv9 = new Vector3f(16.0f, 13.0f, 0.0f);
        Vector3f nxv9 = new Vector3f(-16.0f, 13.0f, 0.0f);
        Vector3f pzv9 = new Vector3f(0.0f, 13.0f, 16.0f);
        Vector3f nzv9 = new Vector3f(0.0f, 13.0f, -16.0f);
        Vector3f ppv9 = new Vector3f(11.5f, 13.0f, 11.5f);
        Vector3f npv9 = new Vector3f(-11.5f, 13.0f, 11.5f);
        Vector3f pnv9 = new Vector3f(11.5f, 13.0f, -11.5f);
        Vector3f nnv9 = new Vector3f(-11.5f, 13.0f, -11.5f);
        Vector3f v9 = new Vector3f(0.0f, 13.0f, 0.0f);
        int time = size * 10;
        if (renderState.ageInTicks > 0.0f && renderState.ageInTicks < (float)(600 + time)) {
            this.addFace(poseStack, quadSolid, pxv1, nzv1, nzv2, pxv2, par5, par6, par7, par8, packedLight);
            this.addFace(poseStack, quadSolid, pzv1, pxv1, pxv2, pzv2, par5, par6, par7, par8, packedLight);
            this.addFace(poseStack, quadSolid, nxv1, pzv1, pzv2, nxv2, par5, par6, par7, par8, packedLight);
            this.addFace(poseStack, quadSolid, nzv1, nxv1, nxv2, nzv2, par5, par6, par7, par8, packedLight);
        }
        if (renderState.ageInTicks > 10.0f && renderState.ageInTicks < (float)(610 + time)) {
            this.addFace(poseStack, quadSolid, pxv2, nzv2, nzv3, pxv3, par5, par6, par7, par8, packedLight);
            this.addFace(poseStack, quadSolid, pzv2, pxv2, pxv3, pzv3, par5, par6, par7, par8, packedLight);
            this.addFace(poseStack, quadSolid, nxv2, pzv2, pzv3, nxv3, par5, par6, par7, par8, packedLight);
            this.addFace(poseStack, quadSolid, nzv2, nxv2, nxv3, nzv3, par5, par6, par7, par8, packedLight);
        }
        if (renderState.ageInTicks > 20.0f && renderState.ageInTicks < (float)(620 + time)) {
            this.addFace(poseStack, quadSolid, pxv3, nzv3, nzv4, pxv4, par5, par6, par7, par8, packedLight);
            this.addFace(poseStack, quadSolid, pzv3, pxv3, pxv4, pzv4, par5, par6, par7, par8, packedLight);
            this.addFace(poseStack, quadSolid, nxv3, pzv3, pzv4, nxv4, par5, par6, par7, par8, packedLight);
            this.addFace(poseStack, quadSolid, nzv3, nxv3, nxv4, nzv4, par5, par6, par7, par8, packedLight);
        }
        if (renderState.ageInTicks > 30.0f && renderState.ageInTicks < (float)(630 + time)) {
            this.addFace(poseStack, quadSolid, pxv4, nzv4, nzv5, pxv5, par5, par6, par7, par8, packedLight);
            this.addFace(poseStack, quadSolid, pzv4, pxv4, pxv5, pzv5, par5, par6, par7, par8, packedLight);
            this.addFace(poseStack, quadSolid, nxv4, pzv4, pzv5, nxv5, par5, par6, par7, par8, packedLight);
            this.addFace(poseStack, quadSolid, nzv4, nxv4, nxv5, nzv5, par5, par6, par7, par8, packedLight);
        }
        if (renderState.ageInTicks > 40.0f && renderState.ageInTicks < (float)(640 + time)) {
            this.addFace(poseStack, quadSolid, pxv5, nzv5, nzv6, pxv6, par5, par6, par7, par8, packedLight);
            this.addFace(poseStack, quadSolid, pzv5, pxv5, pxv6, pzv6, par5, par6, par7, par8, packedLight);
            this.addFace(poseStack, quadSolid, nxv5, pzv5, pzv6, nxv6, par5, par6, par7, par8, packedLight);
            this.addFace(poseStack, quadSolid, nzv5, nxv5, nxv6, nzv6, par5, par6, par7, par8, packedLight);
        }
        if (renderState.ageInTicks > 30.0f && renderState.ageInTicks < (float)(650 + time)) {
            this.addFace(poseStack, quadSolid, pxv6, nzv6, nzv7, pxv7, par6, par5, par8, par7, packedLight);
            this.addFace(poseStack, quadSolid, pzv6, pxv6, pxv7, pzv7, par6, par5, par8, par7, packedLight);
            this.addFace(poseStack, quadSolid, nxv6, pzv6, pzv7, nxv7, par6, par5, par8, par7, packedLight);
            this.addFace(poseStack, quadSolid, nzv6, nxv6, nxv7, nzv7, par6, par5, par8, par7, packedLight);
        }
        if (renderState.ageInTicks > 20.0f && renderState.ageInTicks < (float)(650 + time)) {
            this.addFace(poseStack, quadSolid, pzv7, ppv7, ppv8, pzv8, par6, par5, par8, par7, packedLight);
            this.addFace(poseStack, quadSolid, ppv7, pxv7, pxv8, ppv8, par6, par5, par8, par7, packedLight);
            this.addFace(poseStack, quadSolid, pxv7, pnv7, pnv8, pxv8, par6, par5, par8, par7, packedLight);
            this.addFace(poseStack, quadSolid, pnv7, nzv7, nzv8, pnv8, par6, par5, par8, par7, packedLight);
            this.addFace(poseStack, quadSolid, nzv7, nnv7, nnv8, nzv8, par6, par5, par8, par7, packedLight);
            this.addFace(poseStack, quadSolid, nnv7, nxv7, nxv8, nnv8, par6, par5, par8, par7, packedLight);
            this.addFace(poseStack, quadSolid, nxv7, npv7, npv8, nxv8, par6, par5, par8, par7, packedLight);
            this.addFace(poseStack, quadSolid, npv7, pzv7, pzv8, npv8, par6, par5, par8, par7, packedLight);
        }
        if (renderState.ageInTicks > 10.0f && renderState.ageInTicks < (float)(650 + time)) {
            this.addFace(poseStack, quadSolid, pzv8, ppv8, ppv9, pzv9, par6, par5, par8, par7, packedLight);
            this.addFace(poseStack, quadSolid, ppv8, pxv8, pxv9, ppv9, par6, par5, par8, par7, packedLight);
            this.addFace(poseStack, quadSolid, pxv8, pnv8, pnv9, pxv9, par6, par5, par8, par7, packedLight);
            this.addFace(poseStack, quadSolid, pnv8, nzv8, nzv9, pnv9, par6, par5, par8, par7, packedLight);
            this.addFace(poseStack, quadSolid, nzv8, nnv8, nnv9, nzv9, par6, par5, par8, par7, packedLight);
            this.addFace(poseStack, quadSolid, nnv8, nxv8, nxv9, nnv9, par6, par5, par8, par7, packedLight);
            this.addFace(poseStack, quadSolid, nxv8, npv8, npv9, nxv9, par6, par5, par8, par7, packedLight);
            this.addFace(poseStack, quadSolid, npv8, pzv8, pzv9, npv9, par6, par5, par8, par7, packedLight);
            this.addFace(poseStack, quadSolid, pxv6, pzv6, nxv6, nzv6, par6, par5, par8, par7, packedLight);
            VertexConsumer triangleSolid = bufferSource.getBuffer(RenderTypes.RENDER_SOLID_TRIANGLES.apply(identifier));
            this.addTri(poseStack, triangleSolid, ppv9, v9, pzv9, par6, par5, par8, par7, packedLight);
            this.addTri(poseStack, triangleSolid, pxv9, v9, ppv9, par6, par5, par8, par7, packedLight);
            this.addTri(poseStack, triangleSolid, pnv9, v9, pxv9, par6, par5, par8, par7, packedLight);
            this.addTri(poseStack, triangleSolid, nzv9, v9, pnv9, par6, par5, par8, par7, packedLight);
            this.addTri(poseStack, triangleSolid, nnv9, v9, nzv9, par6, par5, par8, par7, packedLight);
            this.addTri(poseStack, triangleSolid, nxv9, v9, nnv9, par6, par5, par8, par7, packedLight);
            this.addTri(poseStack, triangleSolid, npv9, v9, nxv9, par6, par5, par8, par7, packedLight);
            this.addTri(poseStack, triangleSolid, pzv9, v9, npv9, par6, par5, par8, par7, packedLight);
        }
        poseStack.popPose();
        poseStack.popPose();
    }

    private void addFace(PoseStack poseStack, VertexConsumer buffer, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, float t1, float t2, float t3, float t4, int light) {
        this.addVertice(poseStack, buffer, v1, t1, t4, light);
        this.addVertice(poseStack, buffer, v2, t2, t4, light);
        this.addVertice(poseStack, buffer, v3, t2, t3, light);
        this.addVertice(poseStack, buffer, v4, t1, t3, light);
    }

    private void addTri(PoseStack poseStack, VertexConsumer buffer, Vector3f v1, Vector3f v2, Vector3f v3, float t1, float t2, float t3, float t4, int light) {
        this.addVertice(poseStack, buffer, v3, t1, t4, light);
        this.addVertice(poseStack, buffer, v1, t2, t4, light);
        this.addVertice(poseStack, buffer, v2, t2, t3, light);
    }

    private void addVertice(PoseStack poseStack, VertexConsumer buffer, Vector3f v, float t, float t2, int light) {
        RenderHelper.addVertice(poseStack, buffer, v, new TextureVertice(t, t2), light, OverlayTexture.NO_OVERLAY);
    }

    public boolean shouldRender(EntityNuclearBlast livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    protected int getBlockLightLevel(EntityNuclearBlast entity, BlockPos pos) {
        return 15;
    }

    public State createRenderState() {
        return new State();
    }

    public void extractRenderState(EntityNuclearBlast p_entity, State reusedState, float partialTick) {
        super.extractRenderState((Entity)p_entity, (EntityRenderState)reusedState, partialTick);
        reusedState.deltaMovement = p_entity.getDeltaMovement();
        if (reusedState.ageInTicks == 0.0f) {
            this.textureCoordx = p_entity.getRandom().nextInt(64);
        }
        this.ring1 = Mth.lerp((float)partialTick, (float)this.ring1, (float)(this.ring1 + 0.02f));
        this.ring2 += Mth.sin((float)this.ring1) * 0.01f;
        this.ring3 -= Mth.sin((float)this.ring1) * 0.01f;
        if (this.ring2 < 6.0f) {
            this.ring2 = Mth.lerp((float)partialTick, (float)this.ring2, (float)(this.ring2 + 0.1f));
        }
        if (this.ring3 < 8.0f) {
            this.ring3 = Mth.lerp((float)partialTick, (float)this.ring3, (float)(this.ring3 + 0.1f));
        }
        if (this.height < 8.0f) {
            this.height = Mth.lerp((float)partialTick, (float)this.height, (float)(this.height + 0.1f));
        }
    }

    public static class State
    extends EntityRenderState {
        public Vec3 deltaMovement;
    }
}

