/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.client.model.ModelBlastSphere;
import io.github.kadir1243.rivalrebels.common.entity.EntityPlasmoid;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class RenderPlasmoid
extends EntityRenderer<EntityPlasmoid, State> {
    public RenderPlasmoid(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(State renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.yRot - 90.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(renderState.xRot - 90.0f));
        poseStack.scale(0.4f, 2.5f, 0.4f);
        poseStack.pushPose();
        for (int i = 0; i < 5; ++i) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)renderState.rotation));
            ModelBlastSphere.renderModel(poseStack, bufferSource, 0.4f + 0.2f * (float)i, 0.65f, 0.55f, 0.95f, 0.9f);
        }
        poseStack.popPose();
        poseStack.popPose();
    }

    public boolean shouldRender(EntityPlasmoid livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    protected int getBlockLightLevel(EntityPlasmoid entity, BlockPos pos) {
        return 15;
    }

    public State createRenderState() {
        return new State();
    }

    public void extractRenderState(EntityPlasmoid p_entity, State reusedState, float partialTick) {
        super.extractRenderState((Entity)p_entity, (EntityRenderState)reusedState, partialTick);
        reusedState.xRot = p_entity.getXRot(partialTick);
        reusedState.yRot = p_entity.getYRot(partialTick);
        reusedState.rotation = p_entity.rotation;
    }

    public static class State
    extends EntityRenderState {
        public float xRot;
        public float yRot;
        public int rotation;
    }
}

