/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.client.model.ModelRocket;
import io.github.kadir1243.rivalrebels.common.entity.EntityRocket;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class RenderRocket
extends EntityRenderer<EntityRocket, State> {
    public RenderRocket(EntityRendererProvider.Context manager) {
        super(manager);
    }

    public void render(State renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.yRot - 90.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(renderState.xRot - 90.0f));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)renderState.rotation));
        ModelRocket.render(poseStack, bufferSource, RRIdentifiers.etrocket, renderState.fins, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    public boolean shouldRender(EntityRocket livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    protected int getBlockLightLevel(EntityRocket entity, BlockPos pos) {
        return 15;
    }

    public State createRenderState() {
        return new State();
    }

    public void extractRenderState(EntityRocket p_entity, State reusedState, float partialTick) {
        super.extractRenderState((Entity)p_entity, (EntityRenderState)reusedState, partialTick);
        reusedState.xRot = p_entity.getXRot(partialTick);
        reusedState.yRot = p_entity.getYRot(partialTick);
        reusedState.rotation = p_entity.rotation;
        reusedState.fins = p_entity.fins;
    }

    public static class State
    extends EntityRenderState {
        public float xRot;
        public float yRot;
        public int rotation;
        public boolean fins;
    }
}

