/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.client.model.ModelBlastSphere;
import io.github.kadir1243.rivalrebels.common.entity.EntitySphereBlast;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class RenderSphereBlast
extends EntityRenderer<EntitySphereBlast, EntityRenderState> {
    public RenderSphereBlast(EntityRendererProvider.Context manager) {
        super(manager);
    }

    public void render(EntityRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        double elev = (Mth.sin((float)(renderState.ageInTicks / 40.0f)) + 1.5f) * 10.0f;
        poseStack.translate(0.0, elev, 0.0);
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)(elev * 2.0)));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees((float)(elev * 3.0)));
        ModelBlastSphere.renderModel(poseStack, bufferSource, (float)elev, 1.0f, 0.25f, 0.0f, 1.0f);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)(elev * -2.0)));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)(elev * 4.0)));
        ModelBlastSphere.renderModel(poseStack, bufferSource, (float)(elev - (double)0.2f), 1.0f, 0.5f, 0.0f, 1.0f);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees((float)(elev * -3.0)));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)(elev * 2.0)));
        ModelBlastSphere.renderModel(poseStack, bufferSource, (float)(elev - (double)0.4f), -65536);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)(elev * -1.0)));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)(elev * 3.0)));
        ModelBlastSphere.renderModel(poseStack, bufferSource, (float)(elev - (double)0.6f), 1.0f, 1.0f, 0.0f, 1.0f);
        poseStack.popPose();
        poseStack.popPose();
    }

    public boolean shouldRender(EntitySphereBlast livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public EntityRenderState createRenderState() {
        return new EntityRenderState();
    }

    protected int getBlockLightLevel(EntitySphereBlast entity, BlockPos pos) {
        return 15;
    }
}

