/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.client.model.ModelTheoreticalTsarBomba;
import io.github.kadir1243.rivalrebels.common.entity.EntityTheoreticalTsar;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class RenderTheoreticalTsar
extends EntityRenderer<EntityTheoreticalTsar, State> {
    public RenderTheoreticalTsar(EntityRendererProvider.Context manager) {
        super(manager);
    }

    public void render(State renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.yRot - 90.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(renderState.xRot - 90.0f));
        poseStack.scale(1.3f, 1.3f, 1.3f);
        ModelTheoreticalTsarBomba.render(poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    public boolean shouldRender(EntityTheoreticalTsar livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public State createRenderState() {
        return new State();
    }

    public void extractRenderState(EntityTheoreticalTsar p_entity, State reusedState, float partialTick) {
        super.extractRenderState((Entity)p_entity, (EntityRenderState)reusedState, partialTick);
        reusedState.xRot = p_entity.getXRot(partialTick);
        reusedState.yRot = p_entity.getYRot(partialTick);
    }

    public static class State
    extends EntityRenderState {
        public float xRot;
        public float yRot;
    }
}

