/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.client.model.ModelDisk;
import io.github.kadir1243.rivalrebels.client.renderhelper.RenderTypes;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskLeader;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskOfficer;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskRebel;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskRegular;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskRep;
import io.github.kadir1243.rivalrebels.common.entity.RoddiskBase;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class RoddiskRenderer
extends EntityRenderer<RoddiskBase, State> {
    private float er = 0.0f;

    public RoddiskRenderer(EntityRendererProvider.Context dispatcher) {
        super(dispatcher);
    }

    public void render(State renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(renderState.xRot));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.yRot - 90.0f + this.er));
        poseStack.scale(0.4f, 0.4f, 0.4f);
        poseStack.pushPose();
        RenderType buffer = renderState.isNoiseBuffer ? RenderTypes.CELLULAR_NOISE : RenderType.entitySolid((ResourceLocation)renderState.texture);
        ModelDisk.render(poseStack, bufferSource.getBuffer(buffer), packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        poseStack.popPose();
    }

    public boolean shouldRender(RoddiskBase livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    protected int getBlockLightLevel(RoddiskBase entity, BlockPos pos) {
        return 15;
    }

    public State createRenderState() {
        return new State();
    }

    public void extractRenderState(RoddiskBase p_entity, State reusedState, float partialTick) {
        super.extractRenderState((Entity)p_entity, (EntityRenderState)reusedState, partialTick);
        reusedState.xRot = p_entity.getXRot(partialTick);
        reusedState.yRot = p_entity.getYRot(partialTick);
        reusedState.isNoiseBuffer = p_entity instanceof EntityRoddiskRep;
        RoddiskBase roddiskBase = p_entity;
        Objects.requireNonNull(roddiskBase);
        RoddiskBase roddiskBase2 = roddiskBase;
        int n = 0;
        reusedState.texture = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityRoddiskRegular.class, EntityRoddiskRebel.class, EntityRoddiskOfficer.class, EntityRoddiskLeader.class}, (Object)((Object)roddiskBase2), n)) {
            case 0 -> {
                EntityRoddiskRegular ignored = (EntityRoddiskRegular)roddiskBase2;
                yield RRIdentifiers.etdisk0;
            }
            case 1 -> {
                EntityRoddiskRebel ignored = (EntityRoddiskRebel)roddiskBase2;
                yield RRIdentifiers.etdisk1;
            }
            case 2 -> {
                EntityRoddiskOfficer ignored = (EntityRoddiskOfficer)roddiskBase2;
                yield RRIdentifiers.etdisk2;
            }
            case 3 -> {
                EntityRoddiskLeader ignored = (EntityRoddiskLeader)roddiskBase2;
                yield RRIdentifiers.etdisk3;
            }
            default -> null;
        };
        this.er = Mth.lerp((float)partialTick, (float)this.er, (float)(this.er + 13.46f));
    }

    public static class State
    extends EntityRenderState {
        public float xRot;
        public float yRot;
        public ResourceLocation texture;
        public boolean isNoiseBuffer;
    }
}

