/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderhelper;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.client.model.ObjModels;
import io.github.kadir1243.rivalrebels.client.renderhelper.TrayModelPIPRenderState;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionfc;

public class GuiTrayModelRenderer
extends PictureInPictureRenderer<TrayModelPIPRenderState> {
    private final QuadCollection armModel;
    private final QuadCollection trayModel;
    private final QuadCollection adsdragonModel;

    public GuiTrayModelRenderer(MultiBufferSource.BufferSource bufferSource, ModelManager modelManager) {
        super(bufferSource);
        this.armModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.ARM_MODEL);
        this.trayModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.TRAY_MODEL);
        this.adsdragonModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.ADS_DRAGON_MODEL);
    }

    public Class<TrayModelPIPRenderState> getRenderStateClass() {
        return TrayModelPIPRenderState.class;
    }

    protected void renderToTexture(TrayModelPIPRenderState renderState, PoseStack pose) {
        pose.pushPose();
        pose.translate(renderState.translation());
        pose.scale(-renderState.scale(), renderState.scale(), renderState.scale());
        pose.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
        pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(135.0f));
        pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-135.0f));
        pose.mulPose((Quaternionfc)Axis.XP.rotationDegrees(20.0f));
        if (!renderState.hasWeapon()) {
            pose.translate(0.0f, 0.0f, -0.5f);
            pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)renderState.spinfac()));
            pose.translate(0.0f, 0.0f, 0.5f);
        }
        pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        pose.translate(0.0, -0.75, 1.2600000000000002);
        ObjModels.render(this.trayModel, this.bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.etreciever)), pose, -1, 0xF000F0, OverlayTexture.NO_OVERLAY);
        if (renderState.hasWeapon()) {
            pose.translate(0.0, 0.75, -1.2600000000000002);
            pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)(-Math.atan((float)renderState.x1() / 40.0f) * 40.0)));
            ObjModels.render(this.armModel, this.bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.etreciever)), pose, -1, 0xF000F0, OverlayTexture.NO_OVERLAY);
            pose.mulPose((Quaternionfc)Axis.XP.rotationDegrees((float)(Math.atan((float)renderState.y1() / 40.0f) * 40.0 + 20.0)));
            ObjModels.render(this.adsdragonModel, this.bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.etadsdragon)), pose, -1, 0xF000F0, OverlayTexture.NO_OVERLAY);
        }
        pose.popPose();
    }

    protected String getTextureLabel() {
        return "Tray Model";
    }
}

