/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.tileentityrender;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.client.model.ModelObjective;
import io.github.kadir1243.rivalrebels.common.tileentity.AbstractObjectiveBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public abstract class ObjectiveBlockEntityRenderer<T extends AbstractObjectiveBlockEntity>
implements BlockEntityRenderer<T> {
    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPos) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)this.getTexture()));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        ModelObjective.renderA(poseStack, buffer, packedLight, packedOverlay);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(90.0f));
        ModelObjective.renderB(poseStack, buffer, (float)((AbstractObjectiveBlockEntity)blockEntity).slide, 0.375f, 0.34375f, 0.125f, 0.84375f, packedLight, packedOverlay);
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(-90.0f));
        ModelObjective.renderB(poseStack, buffer, (float)((AbstractObjectiveBlockEntity)blockEntity).slide, 0.125f, 0.34375f, 0.625f, 0.84375f, packedLight, packedOverlay);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        ModelObjective.renderB(poseStack, buffer, (float)((AbstractObjectiveBlockEntity)blockEntity).slide, 0.375f, 0.84375f, 0.625f, 0.84375f, packedLight, packedOverlay);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        ModelObjective.renderB(poseStack, buffer, (float)((AbstractObjectiveBlockEntity)blockEntity).slide, 0.625f, 0.34375f, 0.625f, 0.84375f, packedLight, packedOverlay);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        ModelObjective.renderB(poseStack, buffer, (float)((AbstractObjectiveBlockEntity)blockEntity).slide, 0.875f, 0.84375f, 0.625f, 0.84375f, packedLight, packedOverlay);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(-90.0f));
        ModelObjective.renderB(poseStack, buffer, (float)((AbstractObjectiveBlockEntity)blockEntity).slide, 0.875f, 0.34375f, 0.625f, 0.84375f, packedLight, packedOverlay);
        poseStack.popPose();
    }

    public abstract ResourceLocation getTexture();

    public int getViewDistance() {
        return 16384;
    }

    public AABB getRenderBoundingBox(AbstractObjectiveBlockEntity blockEntity) {
        return AABB.of((BoundingBox)BoundingBox.fromCorners((Vec3i)blockEntity.getBlockPos().offset(-1, -1, -1), (Vec3i)blockEntity.getBlockPos().offset(2, 2, 2)));
    }
}

