/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.tileentityrender;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.kadir1243.rivalrebels.client.renderhelper.QuadHelper;
import io.github.kadir1243.rivalrebels.client.renderhelper.RenderTypes;
import io.github.kadir1243.rivalrebels.client.renderhelper.TextureVertice;
import io.github.kadir1243.rivalrebels.common.block.machine.BlockForceFieldNode;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityForceFieldNode;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityForceFieldNodeRenderer
implements BlockEntityRenderer<TileEntityForceFieldNode> {
    public static final Supplier<QuadHelper.BakedData> BAKED_MODEL = QuadHelper.createBakedModel(buffer -> {
        QuadHelper.addVertice(buffer, new Vector3f(-0.0625f, 3.5f, 0.0f), new TextureVertice(0.0f, 0.0f));
        QuadHelper.addVertice(buffer, new Vector3f(-0.0625f, -3.5f, 0.0f), new TextureVertice(0.0f, 1.0f));
        QuadHelper.addVertice(buffer, new Vector3f(-0.0625f, -3.5f, 35.0f), new TextureVertice(5.0f, 1.0f));
        QuadHelper.addVertice(buffer, new Vector3f(-0.0625f, 3.5f, 35.0f), new TextureVertice(5.0f, 0.0f));
        QuadHelper.addVertice(buffer, new Vector3f(0.0625f, -3.5f, 0.0f), new TextureVertice(0.0f, 1.0f));
        QuadHelper.addVertice(buffer, new Vector3f(0.0625f, 3.5f, 0.0f), new TextureVertice(0.0f, 0.0f));
        QuadHelper.addVertice(buffer, new Vector3f(0.0625f, 3.5f, 35.0f), new TextureVertice(5.0f, 0.0f));
        QuadHelper.addVertice(buffer, new Vector3f(0.0625f, -3.5f, 35.0f), new TextureVertice(5.0f, 1.0f));
    });

    public TileEntityForceFieldNodeRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileEntityForceFieldNode blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPos) {
        if (blockEntity.pInR <= 0.0f) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.translate(0.0f, 0.0f, 0.5f);
        VertexConsumer cellularNoise = bufferSource.getBuffer(RenderTypes.CELLULAR_NOISE);
        ModelBlockRenderer.renderModel((PoseStack.Pose)poseStack.last(), (VertexConsumer)cellularNoise, (BlockStateModel)BAKED_MODEL.get().blockStateModel(), (float)1.0f, (float)1.0f, (float)1.0f, (int)packedLight, (int)packedOverlay);
        poseStack.popPose();
    }

    public int getViewDistance() {
        return 16384;
    }

    public AABB getRenderBoundingBox(TileEntityForceFieldNode entity) {
        float t = 0.0625f;
        float l = 35.0f;
        float h = 3.5f;
        BlockPos pos = entity.getBlockPos();
        return switch ((Direction)entity.getBlockState().getValue(BlockForceFieldNode.FACING)) {
            case Direction.NORTH -> new AABB((double)((float)pos.getX() + 0.5f - t), (double)((float)pos.getY() + 0.5f - h), (double)((float)pos.getZ() - l), (double)((float)pos.getX() + 0.5f + t), (double)((float)pos.getY() + 0.5f + h), (double)pos.getZ());
            case Direction.SOUTH -> new AABB((double)((float)pos.getX() + 0.5f - t), (double)((float)pos.getY() + 0.5f - h), (double)((float)pos.getZ() + 1.0f), (double)((float)pos.getX() + 0.5f + t), (double)((float)pos.getY() + 0.5f + h), (double)((float)pos.getZ() + 1.0f + l));
            case Direction.WEST -> new AABB((double)((float)pos.getX() - l), (double)((float)pos.getY() + 0.5f - h), (double)((float)pos.getZ() + 0.5f - t), (double)pos.getX(), (double)((float)pos.getY() + 0.5f + h), (double)((float)pos.getZ() + 0.5f + t));
            case Direction.EAST -> new AABB((double)((float)pos.getX() + 1.0f), (double)((float)pos.getY() + 0.5f - h), (double)((float)pos.getZ() + 0.5f - t), (double)((float)pos.getX() + 1.0f + l), (double)((float)pos.getY() + 0.5f + h), (double)((float)pos.getZ() + 0.5f + t));
            default -> new AABB(Vec3.ZERO, Vec3.ZERO);
        };
    }
}

