/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.tileentityrender;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.client.model.ModelLoader;
import io.github.kadir1243.rivalrebels.client.model.ObjModels;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityLoaderRenderer
implements BlockEntityRenderer<TileEntityLoader> {
    private final QuadCollection tubeModel = (QuadCollection)Minecraft.getInstance().getModelManager().getStandaloneModel(ObjModels.TUBE_MODEL);

    public TileEntityLoaderRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileEntityLoader blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPos) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.etloader));
        ModelLoader.render(vertexConsumer, poseStack, blockEntity.slide, packedLight, packedOverlay);
        poseStack.popPose();
        for (BlockEntity machine : blockEntity.machines) {
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.5f, 0.5f);
            int xdif = machine.getBlockPos().getX() - blockEntity.getBlockPos().getX();
            int zdif = machine.getBlockPos().getZ() - blockEntity.getBlockPos().getZ();
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)(-90.0 + Math.atan2(xdif, zdif) * 57.2957763671875)));
            poseStack.translate(-1.0f, -0.4f, 0.0f);
            poseStack.scale(0.5f, 0.15f, 0.15f);
            int dist = (int)Mth.sqrt((float)(xdif * xdif + zdif * zdif));
            for (int d = 0; d < dist; ++d) {
                poseStack.translate(2.0f, 0.0f, 0.0f);
                VertexConsumer buffer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.ettube));
                for (BakedQuad bakedQuad : this.tubeModel.getAll()) {
                    buffer.putBulkData(poseStack.last(), bakedQuad, 1.0f, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
                }
            }
            poseStack.popPose();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getViewDistance() {
        return 16384;
    }

    public AABB getRenderBoundingBox(TileEntityLoader blockEntity) {
        return AABB.of((BoundingBox)BoundingBox.fromCorners((Vec3i)blockEntity.getBlockPos().offset(-5, -1, -5), (Vec3i)blockEntity.getBlockPos().offset(6, 2, 6)));
    }
}

