/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.tileentityrender;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.client.model.ModelBlastSphere;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityPlasmaExplosion;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityPlasmaExplosionRenderer
implements BlockEntityRenderer<TileEntityPlasmaExplosion> {
    public TileEntityPlasmaExplosionRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileEntityPlasmaExplosion blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPos) {
        float fsize = Mth.sin((float)blockEntity.size);
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(blockEntity.size * 50.0f));
        ModelBlastSphere.renderModel(poseStack, bufferSource, fsize * 5.5f, 0.45f, 0.45f, 0.65f, 0.4f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(blockEntity.size * 50.0f));
        ModelBlastSphere.renderModel(poseStack, bufferSource, fsize * 5.6f, 0.45f, 0.35f, 0.65f, 0.4f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(blockEntity.size * 50.0f));
        ModelBlastSphere.renderModel(poseStack, bufferSource, fsize * 5.7f, 0.45f, 0.35f, 0.95f, 0.4f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(blockEntity.size * 50.0f));
        ModelBlastSphere.renderModel(poseStack, bufferSource, fsize * 5.8f, 0.45f, 0.35f, 0.65f, 0.4f);
        poseStack.popPose();
        ModelBlastSphere.renderModel(poseStack, bufferSource, fsize * 5.9f, 0.45f, 0.35f, 0.65f, 0.4f);
        poseStack.popPose();
    }

    public int getViewDistance() {
        return 16384;
    }

    public AABB getRenderBoundingBox(TileEntityPlasmaExplosion blockEntity) {
        return AABB.of((BoundingBox)BoundingBox.fromCorners((Vec3i)blockEntity.getBlockPos().offset(-2, -2, -2), (Vec3i)blockEntity.getBlockPos().offset(3, 3, 3)));
    }
}

