/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.tileentityrender;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.client.model.ModelLaptop;
import io.github.kadir1243.rivalrebels.client.model.ModelReactor;
import io.github.kadir1243.rivalrebels.client.model.ObjModels;
import io.github.kadir1243.rivalrebels.client.model.RenderLibrary;
import io.github.kadir1243.rivalrebels.common.block.machine.BlockReactor;
import io.github.kadir1243.rivalrebels.common.packet.ReactorMachinesPacket;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityMachineBase;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityReactor;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityReactorRenderer
implements BlockEntityRenderer<TileEntityReactor> {
    private final QuadCollection electrodeModel = (QuadCollection)Minecraft.getInstance().getModelManager().getStandaloneModel(ObjModels.ELECTRODE_MODEL);

    public TileEntityReactorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileEntityReactor blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPos) {
        Direction facing = (Direction)blockEntity.getBlockState().getValue(BlockReactor.FACING);
        poseStack.pushPose();
        poseStack.translate(0.5f, 1.1875f, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(facing.toYRot()));
        ModelLaptop.renderModel(bufferSource, poseStack, (float)(-blockEntity.slide), packedLight, packedOverlay);
        ModelLaptop.renderScreen(bufferSource, RRIdentifiers.etscreen, poseStack, (float)(-blockEntity.slide), packedLight, packedOverlay);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(facing.toYRot()));
        ModelReactor.renderModel(poseStack, bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.etreactor)), packedLight, packedOverlay);
        poseStack.translate(0.0f, 2.0f, -0.125f);
        poseStack.scale(0.2f, 0.2f, 0.2f);
        VertexConsumer electrodeBuffer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.etelectrode));
        for (BakedQuad quad : this.electrodeModel.getAll()) {
            electrodeBuffer.putBulkData(poseStack.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
        }
        poseStack.popPose();
        HashMap<BlockPos, ReactorMachinesPacket.MachineEntry> entries = new HashMap<BlockPos, ReactorMachinesPacket.MachineEntry>(blockEntity.entries);
        for (TileEntityMachineBase temb : blockEntity.machines) {
            if (!((ReactorMachinesPacket.MachineEntry)entries.get(temb.getBlockPos())).enabled() || !(temb.powerGiven > 0.0f)) continue;
            float radius = temb.powerGiven * temb.powerGiven / 40000.0f;
            radius = (float)((double)radius + 0.03);
            int steps = 2;
            if ((double)radius > 0.05) {
                ++steps;
            }
            if ((double)radius > 0.1) {
                ++steps;
            }
            if ((double)radius > 0.15) {
                ++steps;
            }
            if ((double)radius > 0.25) {
                radius = 0.25f;
            }
            RenderLibrary.renderModel(poseStack, bufferSource, 0.5f, 2.5f, 0.5f, temb.getBlockPos().getX() - blockEntity.getBlockPos().getX(), (float)(temb.getBlockPos().getY() - blockEntity.getBlockPos().getY()) - 2.5f, temb.getBlockPos().getZ() - blockEntity.getBlockPos().getZ(), 0.5f, radius, steps, temb.edist / 2.0f, 0.1f, 0.45f, 0.45f, 0.5f, 0.5f);
        }
    }

    public int getViewDistance() {
        return 16384;
    }

    public AABB getRenderBoundingBox(TileEntityReactor blockEntity) {
        return AABB.of((BoundingBox)BoundingBox.fromCorners((Vec3i)blockEntity.getBlockPos().offset(-100, -100, -100), (Vec3i)blockEntity.getBlockPos().offset(100, 100, 100)));
    }
}

