/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.block;

import com.mojang.serialization.MapCodec;
import io.github.kadir1243.rivalrebels.common.entity.EntityBlood;
import io.github.kadir1243.rivalrebels.common.entity.EntityGoo;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityGore;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockGore
extends BaseEntityBlock {
    public static final MapCodec<BlockGore> CODEC = BlockGore.simpleCodec(BlockGore::new);
    public static final IntegerProperty META = IntegerProperty.create((String)"meta", (int)0, (int)5);
    public static final BooleanProperty IS_UP_FULL = BooleanProperty.create((String)"is_up_full");
    public static final BooleanProperty IS_DOWN_FULL = BooleanProperty.create((String)"is_down_full");
    public static final BooleanProperty IS_NORTH_FULL = BooleanProperty.create((String)"is_north_full");
    public static final BooleanProperty IS_SOUTH_FULL = BooleanProperty.create((String)"is_south_full");
    public static final BooleanProperty IS_WEST_FULL = BooleanProperty.create((String)"is_west_full");
    public static final BooleanProperty IS_EAST_FULL = BooleanProperty.create((String)"is_east_full");

    public BlockGore(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)IS_UP_FULL, (Comparable)Boolean.valueOf(false))).setValue((Property)IS_DOWN_FULL, (Comparable)Boolean.valueOf(false))).setValue((Property)IS_NORTH_FULL, (Comparable)Boolean.valueOf(false))).setValue((Property)IS_SOUTH_FULL, (Comparable)Boolean.valueOf(false))).setValue((Property)IS_WEST_FULL, (Comparable)Boolean.valueOf(false))).setValue((Property)IS_EAST_FULL, (Comparable)Boolean.valueOf(false))).setValue((Property)META, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<BlockGore> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{META, IS_UP_FULL, IS_DOWN_FULL, IS_NORTH_FULL, IS_SOUTH_FULL, IS_WEST_FULL, IS_EAST_FULL});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.isCreative()) {
            int meta = (Integer)state.getValue((Property)META) + 1;
            if (meta >= 6) {
                meta = 0;
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)META, (Comparable)Integer.valueOf(meta)));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (world.isEmptyBlock(pos.below()) && (Integer)state.getValue((Property)META) < 2) {
            world.addFreshEntity((Entity)new EntityBlood(world, (double)pos.getX() + random.nextDouble(), (float)pos.getY() + 0.9f, (double)pos.getZ() + random.nextDouble()));
        } else if (world.isEmptyBlock(pos.below()) && (Integer)state.getValue((Property)META) < 4) {
            world.addFreshEntity((Entity)new EntityGoo(world, (double)pos.getX() + random.nextDouble(), (float)pos.getY() + 0.9f, (double)pos.getZ() + random.nextDouble()));
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!(Block.canSupportCenter((LevelReader)world, (BlockPos)pos.below(), (Direction)Direction.UP) && Block.canSupportCenter((LevelReader)world, (BlockPos)pos.east(), (Direction)Direction.WEST) && Block.canSupportCenter((LevelReader)world, (BlockPos)pos.west(), (Direction)Direction.EAST) && Block.canSupportCenter((LevelReader)world, (BlockPos)pos.south(), (Direction)Direction.NORTH) && Block.canSupportCenter((LevelReader)world, (BlockPos)pos.north(), (Direction)Direction.SOUTH) && Block.canSupportCenter((LevelReader)world, (BlockPos)pos.above(), (Direction)Direction.DOWN))) {
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityGore(pos, state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return BlockGore.updateState((BlockGetter)context.getLevel(), context.getClickedPos(), super.getStateForPlacement(context));
    }

    private static BlockState updateState(BlockGetter level, BlockPos pos, BlockState oldState) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)oldState.setValue((Property)IS_NORTH_FULL, (Comparable)Boolean.valueOf(BlockGore.isFaceFull(level, pos, Direction.NORTH)))).setValue((Property)IS_SOUTH_FULL, (Comparable)Boolean.valueOf(BlockGore.isFaceFull(level, pos, Direction.SOUTH)))).setValue((Property)IS_UP_FULL, (Comparable)Boolean.valueOf(BlockGore.isFaceFull(level, pos, Direction.UP)))).setValue((Property)IS_DOWN_FULL, (Comparable)Boolean.valueOf(BlockGore.isFaceFull(level, pos, Direction.DOWN)))).setValue((Property)IS_EAST_FULL, (Comparable)Boolean.valueOf(BlockGore.isFaceFull(level, pos, Direction.EAST)))).setValue((Property)IS_WEST_FULL, (Comparable)Boolean.valueOf(BlockGore.isFaceFull(level, pos, Direction.WEST)));
    }

    private static boolean isFaceFull(BlockGetter world, BlockPos pos, Direction direction) {
        return world.getBlockState(pos.relative(direction)).isFaceSturdy(world, pos.relative(direction), direction.getOpposite());
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, orientation, movedByPiston);
        BlockState updatedState = BlockGore.updateState((BlockGetter)level, pos, state);
        if (!updatedState.toString().equals(state.toString())) {
            level.setBlockAndUpdate(pos, updatedState);
        }
    }
}

