/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.block.machine;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockForceField
extends Block {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;

    public BlockForceField(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FACING, (Comparable)Direction.DOWN));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public AABB getBoundingBox(BlockState state, BlockGetter source, BlockPos pos) {
        float var6 = 0.4375f;
        return switch (((Direction)state.getValue(FACING)).getAxis()) {
            case Direction.Axis.X -> new AABB(0.0, 0.0, (double)var6, 1.0, 1.0, (double)(1.0f - var6));
            case Direction.Axis.Z -> new AABB((double)var6, 0.0, 0.0, (double)(1.0f - var6), 1.0, 1.0);
            default -> new AABB(0.0, 0.0, (double)var6, 1.0, 1.0, (double)(1.0f - var6));
        };
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        float var6 = 0.4375f;
        return switch (((Direction)state.getValue(FACING)).getAxis()) {
            case Direction.Axis.X -> Shapes.create((double)0.0, (double)0.0, (double)var6, (double)1.0, (double)1.0, (double)(1.0f - var6));
            case Direction.Axis.Z -> Shapes.create((double)var6, (double)0.0, (double)0.0, (double)(1.0f - var6), (double)1.0, (double)1.0);
            default -> super.getCollisionShape(state, world, pos, context);
        };
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        float var6 = 0.4375f;
        return switch (((Direction)state.getValue(FACING)).getAxis()) {
            case Direction.Axis.X -> Shapes.create((double)0.0, (double)0.0, (double)var6, (double)1.0, (double)1.0, (double)(1.0f - var6));
            case Direction.Axis.Z -> Shapes.create((double)var6, (double)0.0, (double)0.0, (double)(1.0f - var6), (double)1.0, (double)1.0);
            default -> super.getShape(state, world, pos, context);
        };
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }
}

