/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.block.trap;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.explosion.Explosion;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockFlare
extends WallTorchBlock {
    public BlockFlare(BlockBehaviour.Properties settings) {
        super(ParticleTypes.LAVA, settings);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return BlockFlare.canSupportCenter((LevelReader)world, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        world.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)x + 0.5, (double)y + 0.6, (double)z + 0.5, 0.0, 0.5, 0.0);
        world.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)x + 0.5, (double)y + 0.8, (double)z + 0.5, 0.0, 0.5, 0.0);
        world.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)x + 0.5, (double)(y + 1), (double)z + 0.5, 0.0, 0.5, 0.0);
        world.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)x + 0.5, (double)y + 1.2, (double)z + 0.5, (-0.5 + (double)random.nextFloat()) * 0.1, 0.5 + (double)random.nextFloat() * 0.5, (-0.5 + (double)random.nextFloat()) * 0.1);
        world.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)x + 0.5, (double)y + 1.4, (double)z + 0.5, (-0.5 + (double)random.nextFloat()) * 0.1, 0.5 + (double)random.nextFloat() * 0.5, (-0.5 + (double)random.nextFloat()) * 0.1);
        world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)x + 0.5, (double)y + 1.6, (double)z + 0.5, (-0.5 + (double)random.nextFloat()) * 0.1, 0.5 + (double)random.nextFloat() * 0.5, (-0.5 + (double)random.nextFloat()) * 0.1);
        world.playLocalSound(pos, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 3.0f, 2.0f, true);
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        super.playerWillDestroy(world, pos, state, player);
        if (RRConfig.SERVER.isFlareExplodeOnBreak()) {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            new Explosion(world, x, y, z, 3, true, false, RivalRebelsDamageSource.flare(world));
            world.playLocalSound(pos, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 0.5f, 0.3f, true);
        }
        return state;
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier p_405359_) {
        entity.hurt(RivalRebelsDamageSource.flare(level), 1.0f);
        entity.igniteForSeconds(5.0f);
    }
}

