/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.block.trap;

import com.mojang.serialization.MapCodec;
import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskLeader;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskOfficer;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskRebel;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskRegular;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockRemoteCharge
extends FallingBlock {
    public static final MapCodec<BlockRemoteCharge> CODEC = BlockRemoteCharge.simpleCodec(BlockRemoteCharge::new);
    public static final IntegerProperty META = IntegerProperty.create((String)"meta", (int)0, (int)15);
    public boolean boom = false;

    public BlockRemoteCharge(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)META, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<BlockRemoteCharge> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{META});
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter world, BlockPos pos) {
        int i = (Integer)state.getValue((Property)META);
        float f = 0.0625f;
        float f1 = (float)(1 + i * 2) / 16.0f;
        float f2 = 0.5f;
        return Shapes.create((double)f1, (double)0.0, (double)f, (double)(1.0f - f), (double)f2, (double)(1.0f - f));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int meta = (Integer)state.getValue((Property)META);
        float f = 0.0625f;
        float f1 = (float)(1 + meta * 2) / 16.0f;
        float f2 = 0.5f;
        return Shapes.create((double)f1, (double)0.0, (double)f, (double)(1.0f - f), (double)(f2 - f), (double)(1.0f - f));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int i = (Integer)state.getValue((Property)META);
        float f = 0.0625f;
        float f1 = (float)(1 + i * 2) / 16.0f;
        float f2 = 0.5f;
        return Shapes.create((double)f1, (double)0.0, (double)f, (double)(1.0f - f), (double)f2, (double)(1.0f - f));
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockRemoteCharge.explode(world, pos);
        return state;
    }

    public void wasExploded(ServerLevel p_361333_, BlockPos p_49845_, Explosion p_49846_) {
        BlockRemoteCharge.explode((Level)p_361333_, p_49845_);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        world.scheduleTick(pos, (Block)this, 1);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        for (Direction facing : Direction.values()) {
            if (!world.getBlockState(pos.relative(facing)).is(BlockTags.FIRE)) continue;
            BlockRemoteCharge.explode((Level)world, pos);
        }
        if (this.boom) {
            BlockRemoteCharge.explode((Level)world, pos);
            this.boom = false;
        }
        world.scheduleTick(pos, (Block)this, 1);
    }

    public int getDustColor(BlockState state, BlockGetter level, BlockPos pos) {
        return -1;
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier p_405359_) {
        if (entity instanceof EntityRoddiskRegular || entity instanceof EntityRoddiskRebel || entity instanceof EntityRoddiskOfficer || entity instanceof EntityRoddiskLeader) {
            BlockRemoteCharge.explode(level, pos);
        }
    }

    public static void explode(Level world, BlockPos pos) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        new io.github.kadir1243.rivalrebels.common.explosion.Explosion(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, RRConfig.SERVER.getChargeExplosionSize(), false, false, RivalRebelsDamageSource.charge(world));
        world.playLocalSound(pos, (SoundEvent)RRSounds.REMOTE_CHARGE_EXPLOSION.get(), SoundSource.BLOCKS, 1.0f, 0.3f, false);
    }

    public void onLand(Level world, BlockPos pos, BlockState fallingBlockState, BlockState currentStateInPos, FallingBlockEntity fallingBlockEntity) {
        BlockRemoteCharge.explode(world, pos);
    }
}

