/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.block.trap;

import com.mojang.serialization.MapCodec;
import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BlockTimedBomb
extends FallingBlock {
    public static final MapCodec<BlockTimedBomb> CODEC = AnvilBlock.simpleCodec(BlockTimedBomb::new);
    int ticksSincePlaced = 0;

    public BlockTimedBomb(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected MapCodec<BlockTimedBomb> codec() {
        return CODEC;
    }

    public void wasExploded(ServerLevel world, BlockPos pos, Explosion explosion) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        new io.github.kadir1243.rivalrebels.common.explosion.Explosion((Level)world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, RRConfig.SERVER.getTimedbombExplosionSize(), false, true, RivalRebelsDamageSource.timedBomb((Level)world));
        world.playSound(null, pos, (SoundEvent)RRSounds.TIMED_BOMB_SOUND.get(), SoundSource.BLOCKS, 2.0f, 0.3f);
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        new io.github.kadir1243.rivalrebels.common.explosion.Explosion(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, RRConfig.SERVER.getTimedbombExplosionSize(), false, true, RivalRebelsDamageSource.timedBomb(world));
        world.playSound(null, pos, (SoundEvent)RRSounds.TIMED_BOMB_SOUND.get(), SoundSource.BLOCKS, 2.0f, 0.3f);
        return state;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        this.ticksSincePlaced = 0;
        world.scheduleTick(pos, (Block)this, 8);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        world.scheduleTick(pos, (Block)this, 8);
        ++this.ticksSincePlaced;
        if ((double)this.ticksSincePlaced >= (double)RRConfig.SERVER.getTimedbombTimer() * 2.5) {
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            new io.github.kadir1243.rivalrebels.common.explosion.Explosion((Level)world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, RRConfig.SERVER.getTimedbombExplosionSize(), false, true, RivalRebelsDamageSource.timedBomb((Level)world));
            world.playSound(null, pos, (SoundEvent)RRSounds.TIMED_BOMB_SOUND.get(), SoundSource.BLOCKS, 2.0f, 0.3f);
        }
        if (this.ticksSincePlaced == 100) {
            this.ticksSincePlaced = 0;
        }
        if (world.getBlockState(pos.above()).is(RRBlocks.light) && this.ticksSincePlaced <= 93) {
            world.setBlockAndUpdate(pos.above(), Blocks.AIR.defaultBlockState());
            world.playLocalSound(pos, (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 1.0f, 1.0f, true);
        } else if (this.ticksSincePlaced <= 93) {
            world.setBlockAndUpdate(pos.above(), ((Block)RRBlocks.light.get()).defaultBlockState());
            world.playLocalSound(pos, (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 1.0f, 0.7f, true);
        } else {
            world.playLocalSound(pos, (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 2.0f, 2.0f, true);
        }
    }

    public int getDustColor(BlockState state, BlockGetter level, BlockPos pos) {
        return -1;
    }

    protected void falling(FallingBlockEntity entity) {
        Level level = entity.level();
        new io.github.kadir1243.rivalrebels.common.explosion.Explosion(level, entity.getX() + 0.5, entity.getY() + 0.5, entity.getZ() + 0.5, RRConfig.SERVER.getTimedbombExplosionSize(), false, true, RivalRebelsDamageSource.timedBomb(level));
        level.playSound(null, entity.blockPosition(), (SoundEvent)RRSounds.TIMED_BOMB_SOUND.get(), SoundSource.BLOCKS, 2.0f, 0.3f);
    }
}

