/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.container;

import io.github.kadir1243.rivalrebels.common.block.trap.BlockTimedBomb;
import io.github.kadir1243.rivalrebels.common.container.BombContainer;
import io.github.kadir1243.rivalrebels.common.container.SlotRR;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsGuiHandler;
import io.github.kadir1243.rivalrebels.common.item.ItemChip;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import net.minecraft.core.Holder;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ContainerAntimatterBomb
extends AbstractContainerMenu
implements BombContainer {
    protected Container antimatter;
    private final ContainerData containerData;

    public ContainerAntimatterBomb(int syncId, Inventory inv) {
        this(syncId, inv, (Container)new SimpleContainer(36), (ContainerData)new SimpleContainerData(4));
    }

    public ContainerAntimatterBomb(int syncId, Inventory inv, Container antimatter, ContainerData containerData) {
        super((MenuType)RivalRebelsGuiHandler.ANTIMATTER_SCREEN_HANDLER_TYPE.get(), syncId);
        this.antimatter = antimatter;
        this.containerData = containerData;
        this.addSlot(new SlotRR(antimatter, 0, 18, 48, 1, (Holder<Item>)RRItems.fuse));
        this.addSlot(new SlotRR(antimatter, 1, 40, 59, 1, (Holder<Item>)RRItems.antenna));
        this.addSlot(new SlotRR(antimatter, 2, 40, 37, 1, (Holder<Item>)RRItems.antenna));
        for (int i = 0; i <= 3; ++i) {
            this.addSlot(new SlotRR(antimatter, i + 3, 62 + i * 18, 19, 1, (Holder<Item>)RRItems.NUCLEAR_ROD).setAcceptsTrollface(true));
            this.addSlot(new SlotRR(antimatter, i + 7, 62 + i * 18, 37, 1, (Holder<Item>)RRItems.NUCLEAR_ROD).setAcceptsTrollface(true));
            this.addSlot(new SlotRR(antimatter, i + 11, 62 + i * 18, 59, 1, (Holder<Item>)RRItems.redrod).setAcceptsTrollface(true));
            this.addSlot(new SlotRR(antimatter, i + 15, 62 + i * 18, 77, 1, (Holder<Item>)RRItems.redrod).setAcceptsTrollface(true));
        }
        this.addSlot(new SlotRR(antimatter, 19, 138, 48, 1, BlockTimedBomb.class));
        this.addSlot(new SlotRR(antimatter, 20, 98, 99, 1, ItemChip.class));
        this.bindPlayerInventory(inv);
        this.addDataSlots(containerData);
    }

    public boolean stillValid(Player player) {
        return this.antimatter.stillValid(player);
    }

    protected void bindPlayerInventory(Inventory inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 119 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 175));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = this.getSlot(index);
        if (slot != null && slot.hasItem()) {
            ItemStack var5 = slot.getItem();
            itemStack = var5.copy();
            if (index <= 19 ? !this.moveItemStackTo(var5, 19, this.slots.size(), true) : !this.moveItemStackTo(var5, 0, 19, false)) {
                return ItemStack.EMPTY;
            }
            if (var5.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    @Override
    public int getCountdown() {
        return this.containerData.get(0);
    }

    public boolean isUnbalanced() {
        return this.containerData.get(1) == 1;
    }

    public boolean isArmed() {
        return this.containerData.get(2) == 1;
    }

    public float getMegaton() {
        return (float)this.containerData.get(3) / 100.0f;
    }
}

