/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.container;

import io.github.kadir1243.rivalrebels.common.container.SlotRR;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsGuiHandler;
import io.github.kadir1243.rivalrebels.common.item.components.RRComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerReactor
extends AbstractContainerMenu {
    protected Container reactor;
    public SlotRR fuel;
    public SlotRR core;
    private final ContainerData containerData;

    public ContainerReactor(int syncId, Inventory playerInv) {
        this(syncId, playerInv, (Container)new SimpleContainer(2), (ContainerData)new SimpleContainerData(7));
    }

    public ContainerReactor(int syncId, Inventory inv, Container reactor, ContainerData containerData) {
        super((MenuType)RivalRebelsGuiHandler.REACTOR_SCREEN_HANDLER_TYPE.get(), syncId);
        this.reactor = reactor;
        this.fuel = new SlotRR(reactor, 0, 58, 139, 1, (DataComponentType)RRComponents.ROD_POWER.get());
        this.core = new SlotRR(reactor, 1, 103, 139, 1, (DataComponentType)RRComponents.CORE_TIME_MULTIPLIER.get());
        this.containerData = containerData;
        this.addSlot(this.fuel);
        this.addSlot(this.core);
        this.bindPlayerInventory((Container)inv);
        this.addDataSlots(containerData);
    }

    public boolean stillValid(Player player) {
        return this.reactor.stillValid(player);
    }

    protected void bindPlayerInventory(Container inventoryPlayer) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot(inventoryPlayer, i, 8 + i * 18, 172));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public boolean isOn() {
        return this.containerData.get(0) == 1;
    }

    public float getPower() {
        return (float)this.containerData.get(1) * 100.0f;
    }

    public int getConsumed() {
        return this.containerData.get(2);
    }

    public int getLastTickConsumed() {
        return this.containerData.get(2);
    }

    public boolean isMelt() {
        return this.containerData.get(3) == 1;
    }

    public BlockPos getPos() {
        return new BlockPos(this.containerData.get(4), this.containerData.get(5), this.containerData.get(6));
    }
}

