/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.container;

import io.github.kadir1243.rivalrebels.common.block.crate.BlockWeapons;
import io.github.kadir1243.rivalrebels.common.container.SlotRR;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsGuiHandler;
import io.github.kadir1243.rivalrebels.common.item.ItemChip;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerReciever
extends AbstractContainerMenu {
    protected Container reciever;
    private final ContainerData containerData;

    public ContainerReciever(int syncId, Inventory playerInv) {
        this(syncId, playerInv, (Container)new SimpleContainer(9), (ContainerData)new SimpleContainerData(7));
    }

    public ContainerReciever(int syncId, Inventory inventoryPlayer, Container reciever, ContainerData containerData) {
        super((MenuType)RivalRebelsGuiHandler.RECIEVER_SCREEN_HANDLER_TYPE.get(), syncId);
        this.reciever = reciever;
        this.containerData = containerData;
        this.addSlot(new SlotRR(reciever, 0, 8, 76, 64, RRItems.fuel.asItem()));
        this.addSlot(new SlotRR(reciever, 1, 26, 76, 64, RRItems.fuel.asItem()));
        this.addSlot(new SlotRR(reciever, 2, 44, 76, 64, RRItems.fuel.asItem()));
        this.addSlot(new SlotRR(reciever, 3, 8, 94, 16, RRItems.battery.asItem()));
        this.addSlot(new SlotRR(reciever, 4, 26, 94, 16, RRItems.battery.asItem()));
        this.addSlot(new SlotRR(reciever, 5, 44, 94, 16, RRItems.battery.asItem()));
        this.addSlot(new SlotRR(reciever, 6, 116, 94, 1, ItemChip.class));
        this.addSlot(new SlotRR(reciever, 7, 134, 94, 1, BlockWeapons.class));
        this.addSlot(new SlotRR(reciever, 8, 152, 94, 1, BlockWeapons.class));
        this.bindPlayerInventory(inventoryPlayer);
        this.addDataSlots(containerData);
    }

    public boolean stillValid(Player player) {
        return this.reciever.stillValid(player);
    }

    protected void bindPlayerInventory(Inventory inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 119 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 175));
        }
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        return ItemStack.EMPTY;
    }

    public int getYawLimit() {
        return this.containerData.get(0);
    }

    public void setYawLimit(int yawLimit) {
        this.containerData.set(0, yawLimit);
    }

    public boolean getKTeam() {
        return this.containerData.get(1) == 1;
    }

    public boolean getKPlayers() {
        return this.containerData.get(2) == 1;
    }

    public boolean getKMobs() {
        return this.containerData.get(3) == 1;
    }

    public void setKTeam(boolean kTeam) {
        this.containerData.set(1, kTeam ? 1 : 0);
    }

    public void setKPlayers(boolean kPlayers) {
        this.containerData.set(2, kPlayers ? 1 : 0);
    }

    public void setKMobs(boolean kMobs) {
        this.containerData.set(3, kMobs ? 1 : 0);
    }

    public boolean hasWeapon() {
        return this.containerData.get(4) == 1;
    }

    public boolean hasWepReqs() {
        return this.containerData.get(5) == 1;
    }

    public void setWep(boolean wep) {
        this.containerData.set(5, wep ? 1 : 0);
    }

    public float getPInR() {
        return Float.intBitsToFloat(this.containerData.get(6));
    }
}

